/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import pl.gsmservice.gateway.utils.Utils;

public class PingResponse {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="status")
    private Optional<String> status;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="version")
    private Optional<String> version;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="sandbox")
    private Optional<Boolean> sandbox;

    @JsonCreator
    public PingResponse(@JsonProperty(value="status") Optional<String> status, @JsonProperty(value="version") Optional<String> version, @JsonProperty(value="sandbox") Optional<Boolean> sandbox) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(version, "version");
        Utils.checkNotNull(sandbox, "sandbox");
        this.status = status;
        this.version = version;
        this.sandbox = sandbox;
    }

    public PingResponse() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> status() {
        return this.status;
    }

    @JsonIgnore
    public Optional<String> version() {
        return this.version;
    }

    @JsonIgnore
    public Optional<Boolean> sandbox() {
        return this.sandbox;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public PingResponse withStatus(String status) {
        Utils.checkNotNull(status, "status");
        this.status = Optional.ofNullable(status);
        return this;
    }

    public PingResponse withStatus(Optional<String> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public PingResponse withVersion(String version) {
        Utils.checkNotNull(version, "version");
        this.version = Optional.ofNullable(version);
        return this;
    }

    public PingResponse withVersion(Optional<String> version) {
        Utils.checkNotNull(version, "version");
        this.version = version;
        return this;
    }

    public PingResponse withSandbox(boolean sandbox) {
        Utils.checkNotNull(sandbox, "sandbox");
        this.sandbox = Optional.ofNullable(sandbox);
        return this;
    }

    public PingResponse withSandbox(Optional<Boolean> sandbox) {
        Utils.checkNotNull(sandbox, "sandbox");
        this.sandbox = sandbox;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PingResponse other = (PingResponse)o;
        return Objects.deepEquals(this.status, other.status) && Objects.deepEquals(this.version, other.version) && Objects.deepEquals(this.sandbox, other.sandbox);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.version, this.sandbox);
    }

    public String toString() {
        return Utils.toString(PingResponse.class, "status", this.status, "version", this.version, "sandbox", this.sandbox);
    }

    public static final class Builder {
        private Optional<String> status = Optional.empty();
        private Optional<String> version = Optional.empty();
        private Optional<Boolean> sandbox = Optional.empty();

        private Builder() {
        }

        public Builder status(String status) {
            Utils.checkNotNull(status, "status");
            this.status = Optional.ofNullable(status);
            return this;
        }

        public Builder status(Optional<String> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder version(String version) {
            Utils.checkNotNull(version, "version");
            this.version = Optional.ofNullable(version);
            return this;
        }

        public Builder version(Optional<String> version) {
            Utils.checkNotNull(version, "version");
            this.version = version;
            return this;
        }

        public Builder sandbox(boolean sandbox) {
            Utils.checkNotNull(sandbox, "sandbox");
            this.sandbox = Optional.ofNullable(sandbox);
            return this;
        }

        public Builder sandbox(Optional<Boolean> sandbox) {
            Utils.checkNotNull(sandbox, "sandbox");
            this.sandbox = sandbox;
            return this;
        }

        public PingResponse build() {
            return new PingResponse(this.status, this.version, this.sandbox);
        }
    }
}

