/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.utils;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import pl.gsmservice.gateway.utils.NameValue;

final class QueryEncoding {
    private static final int RADIX = 16;
    private static final char QUERY_PARAM_SEPARATOR = '&';
    private static final char PARAM_VALUE_SEPARATOR = '=';
    private static final BitSet UNRESERVED;

    QueryEncoding() {
    }

    static String formatQuery(Iterable<? extends NameValue> parameters, Charset charset, boolean blankAsPlus) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        for (NameValue nameValue : parameters) {
            if (i > 0) {
                buf.append('&');
            }
            QueryEncoding.percentEncode(buf, nameValue.name(), charset, blankAsPlus);
            if (nameValue.value() != null) {
                buf.append('=');
                QueryEncoding.percentEncode(buf, nameValue.value(), charset, blankAsPlus);
            }
            ++i;
        }
        return buf.toString();
    }

    private static void percentEncode(StringBuilder buf, CharSequence content, Charset charset, boolean blankAsPlus) {
        QueryEncoding.percentEncode(buf, content, charset, UNRESERVED, blankAsPlus);
    }

    private static void percentEncode(StringBuilder buf, CharSequence content, Charset charset, BitSet safechars, boolean blankAsPlus) {
        if (content == null) {
            return;
        }
        CharBuffer cb = CharBuffer.wrap(content);
        ByteBuffer bb = (charset != null ? charset : StandardCharsets.UTF_8).encode(cb);
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (safechars.get(b)) {
                buf.append((char)b);
                continue;
            }
            if (blankAsPlus && b == 32) {
                buf.append("+");
                continue;
            }
            buf.append("%");
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            buf.append(hex1);
            buf.append(hex2);
        }
    }

    static {
        int i;
        UNRESERVED = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            UNRESERVED.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            UNRESERVED.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            UNRESERVED.set(i);
        }
        UNRESERVED.set(45);
        UNRESERVED.set(46);
        UNRESERVED.set(95);
        UNRESERVED.set(126);
    }
}

