/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.utils;

import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import pl.gsmservice.gateway.utils.HTTPRequest;
import pl.gsmservice.gateway.utils.SecurityMetadata;
import pl.gsmservice.gateway.utils.SpeakeasyMetadata;
import pl.gsmservice.gateway.utils.Types;
import pl.gsmservice.gateway.utils.Utils;

public final class Security {
    private Security() {
    }

    public static HTTPRequest configureSecurity(HTTPRequest request, Object security) throws Exception {
        if (security != null) {
            Field[] fields;
            for (Field field : fields = security.getClass().getDeclaredFields()) {
                SecurityMetadata securityMetadata;
                field.setAccessible(true);
                Object value = Utils.resolveOptionals(field.get(security));
                if (value == null || (securityMetadata = SecurityMetadata.parse(field)) == null) continue;
                if (securityMetadata.option) {
                    Security.parseSecurityOption(request, value);
                    continue;
                }
                if (!securityMetadata.scheme) continue;
                if (securityMetadata.subtype != null && securityMetadata.subtype.equals("basic") && Types.getType(value.getClass()) != Types.OBJECT) {
                    Security.parseSecurityScheme(request, securityMetadata, security);
                    continue;
                }
                Security.parseSecurityScheme(request, securityMetadata, value);
            }
        }
        return request;
    }

    private static void parseSecurityOption(HTTPRequest request, Object option) throws Exception {
        Field[] fields;
        for (Field field : fields = option.getClass().getDeclaredFields()) {
            SecurityMetadata securityMetadata;
            field.setAccessible(true);
            Object value = Utils.resolveOptionals(field.get(option));
            if (value == null || (securityMetadata = SecurityMetadata.parse(field)) == null || !securityMetadata.scheme) continue;
            Security.parseSecurityScheme(request, securityMetadata, value);
        }
    }

    private static void parseSecurityScheme(HTTPRequest requestBuilder, SecurityMetadata schemeMetadata, Object scheme) throws Exception {
        if (Types.getType(scheme.getClass()) == Types.OBJECT) {
            Field[] fields;
            if (schemeMetadata.type.equals("http") && schemeMetadata.subtype.equals("basic")) {
                Security.parseBasicAuthScheme(requestBuilder, scheme);
                return;
            }
            for (Field field : fields = scheme.getClass().getDeclaredFields()) {
                SecurityMetadata securityMetadata;
                field.setAccessible(true);
                Object value = Utils.resolveOptionals(field.get(scheme));
                if (value == null || (securityMetadata = SecurityMetadata.parse(field)) == null || securityMetadata.name.isEmpty()) continue;
                Security.parseSecuritySchemeValue(requestBuilder, schemeMetadata, securityMetadata, value);
            }
        } else {
            Security.parseSecuritySchemeValue(requestBuilder, schemeMetadata, schemeMetadata, scheme);
        }
    }

    private static void parseSecuritySchemeValue(HTTPRequest request, SecurityMetadata schemeMetadata, SecurityMetadata securityMetadata, Object value) throws Exception {
        block6 : switch (schemeMetadata.type) {
            case "apiKey": {
                switch (schemeMetadata.subtype) {
                    case "header": {
                        request.addHeader(securityMetadata.name, Utils.valToString(value));
                        break block6;
                    }
                    case "query": {
                        request.addQueryParam(securityMetadata.name, Utils.valToString(value), false);
                        break block6;
                    }
                    case "cookie": {
                        request.addHeader("Cookie", String.format("%s=%s", securityMetadata.name, Utils.valToString(value)));
                        break block6;
                    }
                }
                throw new RuntimeException("Unsupported security scheme subtype for apiKey: " + securityMetadata.subtype);
            }
            case "openIdConnect": {
                request.addHeader(securityMetadata.name, Utils.prefixBearer(Utils.valToString(value)));
                break;
            }
            case "oauth2": {
                if ("client_credentials".equals(schemeMetadata.subtype)) break;
                request.addHeader(securityMetadata.name, Utils.prefixBearer(Utils.valToString(value)));
                break;
            }
            case "http": {
                switch (schemeMetadata.subtype) {
                    case "bearer": {
                        request.addHeader(securityMetadata.name, Utils.prefixBearer(Utils.valToString(value)));
                        break block6;
                    }
                }
                throw new RuntimeException("Unsupported security scheme subtype for bearer");
            }
            default: {
                throw new RuntimeException("Unsupported security scheme type");
            }
        }
    }

    private static void parseBasicAuthScheme(HTTPRequest requestBuilder, Object scheme) throws IllegalAccessException {
        Field[] fields = scheme.getClass().getDeclaredFields();
        String username = "";
        String password = "";
        block8: for (Field field : fields) {
            SecurityMetadata securityMetadata;
            field.setAccessible(true);
            Object value = Utils.resolveOptionals(field.get(scheme));
            if (value == null || (securityMetadata = SecurityMetadata.parse(field)) == null || securityMetadata.name.isEmpty()) continue;
            switch (securityMetadata.name) {
                case "username": {
                    username = Utils.valToString(value);
                    continue block8;
                }
                case "password": {
                    password = Utils.valToString(value);
                    continue block8;
                }
                default: {
                    throw new RuntimeException("Unsupported security scheme field for basic auth: " + securityMetadata.name);
                }
            }
        }
        requestBuilder.addHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString(String.format("%s:%s", username, password).getBytes(StandardCharsets.UTF_8)));
    }

    public static Stream<Field> findFieldsWhereMetadataContainsRegexes(Object o, String ... regexes) {
        Field[] fields = o.getClass().getDeclaredFields();
        return Arrays.stream(fields).filter(f -> {
            SpeakeasyMetadata[] anns = (SpeakeasyMetadata[])f.getDeclaredAnnotationsByType(SpeakeasyMetadata.class);
            if (anns == null) {
                return false;
            }
            return Arrays.stream(regexes).allMatch(regex -> Security.matches(anns, regex));
        });
    }

    public static Optional<String> findStringValueWhereMetadataContainsRegexes(Object o, String ... regexes) {
        return Security.findValueWhereMetadataContainsRegexes(o, regexes).map(x -> (String)x);
    }

    public static Optional<String> findStringValueWhereMetadataNameIs(Object o, String name) {
        return Security.findStringValueWhereMetadataContainsRegexes(o, "\\bname=" + name + "\\b");
    }

    public static Optional<Object> findValueWhereMetadataContainsRegexes(Object o, String ... regexes) {
        return Security.findFieldsWhereMetadataContainsRegexes(o, regexes).flatMap(f -> {
            Object result;
            f.setAccessible(true);
            try {
                result = f.get(o);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            if (result instanceof Optional) {
                Optional r = (Optional)result;
                if (r.isEmpty()) {
                    return Stream.empty();
                }
                return Stream.of(r.get());
            }
            return Stream.of(result);
        }).findAny();
    }

    private static boolean matches(SpeakeasyMetadata[] anns, String regex) {
        Pattern pattern = Pattern.compile(regex);
        for (SpeakeasyMetadata ann : anns) {
            if (!pattern.matcher(ann.value()).find()) continue;
            return true;
        }
        return false;
    }
}

