/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway;

import static pl.gsmservice.gateway.operations.Operations.RequestlessOperation;
import static pl.gsmservice.gateway.operations.Operations.RequestOperation;

import java.lang.Exception;
import java.lang.String;
import java.util.Optional;
import pl.gsmservice.gateway.models.operations.GetAccountDetailsRequestBuilder;
import pl.gsmservice.gateway.models.operations.GetAccountDetailsResponse;
import pl.gsmservice.gateway.models.operations.GetSubaccountDetailsRequest;
import pl.gsmservice.gateway.models.operations.GetSubaccountDetailsRequestBuilder;
import pl.gsmservice.gateway.models.operations.GetSubaccountDetailsResponse;
import pl.gsmservice.gateway.operations.GetAccountDetails;
import pl.gsmservice.gateway.operations.GetSubaccountDetails;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;


public class Accounts {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncAccounts asyncSDK;

    Accounts(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncAccounts(this, sdkConfiguration);
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncAccounts async() {
        return asyncSDK;
    }

    /**
     * Get account details
     * 
     * <p>
 * <br>
 * <br>Get current account balance and other details of your account. You can check also account limit and if account is main one. Main accounts have unlimited privileges and using <a href="https://panel.szybkisms.pl">User Panel</a> you can create as many subaccounts as you need.
 * <br>
 * <br>This method doesn't take any parameters. As a successful result a details of current account you are logged in using an API Access Token will be returned.
     * 
     * @return The call builder
     */
    public GetAccountDetailsRequestBuilder get() {
        return new GetAccountDetailsRequestBuilder(sdkConfiguration);
    }

    /**
     * Get account details
     * 
     * <p>
 * <br>
 * <br>Get current account balance and other details of your account. You can check also account limit and if account is main one. Main accounts have unlimited privileges and using <a href="https://panel.szybkisms.pl">User Panel</a> you can create as many subaccounts as you need.
 * <br>
 * <br>This method doesn't take any parameters. As a successful result a details of current account you are logged in using an API Access Token will be returned.
     * 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetAccountDetailsResponse getDirect() throws Exception {
        return get(Optional.empty());
    }

    /**
     * Get account details
     * 
     * <p>
 * <br>
 * <br>Get current account balance and other details of your account. You can check also account limit and if account is main one. Main accounts have unlimited privileges and using <a href="https://panel.szybkisms.pl">User Panel</a> you can create as many subaccounts as you need.
 * <br>
 * <br>This method doesn't take any parameters. As a successful result a details of current account you are logged in using an API Access Token will be returned.
     * 
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetAccountDetailsResponse get(Optional<Options> options) throws Exception {
        RequestlessOperation<GetAccountDetailsResponse> operation
            = new GetAccountDetails.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest());
    }

    /**
     * Get subaccount details
     * 
     * <p>
 * <br>
 * <br>Check account balance and other details such subcredit balance of a subaccount. Subaccounts are additional users who can access your account services and the details. You can restrict access level and setup privileges to subaccounts using <a href="https://panel.szybkisms.pl">User Panel</a>.
 * <br>
 * <br>You should pass the subaccount user login to access its data. Please use builder style: 
 * <br>
     * <pre><code>
     * GetSubaccountDetailsResponse res = sdk.accounts().getSubaccount()
     *    .userLogin("some-login")
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result the details of subaccount with provided login will be returned.
     * 
     * @return The call builder
     */
    public GetSubaccountDetailsRequestBuilder getSubaccount() {
        return new GetSubaccountDetailsRequestBuilder(sdkConfiguration);
    }

    /**
     * Get subaccount details
     * 
     * <p>
 * <br>
 * <br>Check account balance and other details such subcredit balance of a subaccount. Subaccounts are additional users who can access your account services and the details. You can restrict access level and setup privileges to subaccounts using <a href="https://panel.szybkisms.pl">User Panel</a>.
 * <br>
 * <br>You should pass the subaccount user login to access its data. Please use builder style: 
 * <br>
     * <pre><code>
     * GetSubaccountDetailsResponse res = sdk.accounts().getSubaccount()
     *    .userLogin("some-login")
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result the details of subaccount with provided login will be returned.
     * 
     * @param userLogin Login of the subaccount (user) to get the data for
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetSubaccountDetailsResponse getSubaccount(String userLogin) throws Exception {
        return getSubaccount(userLogin, Optional.empty());
    }

    /**
     * Get subaccount details
     * 
     * <p>
 * <br>
 * <br>Check account balance and other details such subcredit balance of a subaccount. Subaccounts are additional users who can access your account services and the details. You can restrict access level and setup privileges to subaccounts using <a href="https://panel.szybkisms.pl">User Panel</a>.
 * <br>
 * <br>You should pass the subaccount user login to access its data. Please use builder style: 
 * <br>
     * <pre><code>
     * GetSubaccountDetailsResponse res = sdk.accounts().getSubaccount()
     *    .userLogin("some-login")
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result the details of subaccount with provided login will be returned.
     * 
     * @param userLogin Login of the subaccount (user) to get the data for
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetSubaccountDetailsResponse getSubaccount(String userLogin, Optional<Options> options) throws Exception {
        GetSubaccountDetailsRequest request =
            GetSubaccountDetailsRequest
                .builder()
                .userLogin(userLogin)
                .build();
        RequestOperation<GetSubaccountDetailsRequest, GetSubaccountDetailsResponse> operation
              = new GetSubaccountDetails.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

}
