/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway;

import static pl.gsmservice.gateway.operations.Operations.AsyncRequestlessOperation;
import static pl.gsmservice.gateway.operations.Operations.AsyncRequestOperation;

import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.gsmservice.gateway.models.operations.GetSubaccountDetailsRequest;
import pl.gsmservice.gateway.models.operations.async.GetAccountDetailsRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.GetAccountDetailsResponse;
import pl.gsmservice.gateway.models.operations.async.GetSubaccountDetailsRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.GetSubaccountDetailsResponse;
import pl.gsmservice.gateway.operations.GetAccountDetails;
import pl.gsmservice.gateway.operations.GetSubaccountDetails;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;


public class AsyncAccounts {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Accounts syncSDK;

    AsyncAccounts(Accounts syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public Accounts sync() {
        return syncSDK;
    }


    /**
     * Get account details
     * 
     * <p>
 * <br>
 * <br>Get current account balance and other details of your account. You can check also account limit and if account is main one. Main accounts have unlimited privileges and using <a href="https://panel.szybkisms.pl">User Panel</a> you can create as many subaccounts as you need.
 * <br>
 * <br>This method doesn't take any parameters. As a successful result a details of current account you are logged in using an API Access Token will be returned.
     * 
     * @return The async call builder
     */
    public GetAccountDetailsRequestBuilder get() {
        return new GetAccountDetailsRequestBuilder(sdkConfiguration);
    }

    /**
     * Get account details
     * 
     * <p>
 * <br>
 * <br>Get current account balance and other details of your account. You can check also account limit and if account is main one. Main accounts have unlimited privileges and using <a href="https://panel.szybkisms.pl">User Panel</a> you can create as many subaccounts as you need.
 * <br>
 * <br>This method doesn't take any parameters. As a successful result a details of current account you are logged in using an API Access Token will be returned.
     * 
     * @return CompletableFuture&lt;GetAccountDetailsResponse&gt; - The async response
     */
    public CompletableFuture<GetAccountDetailsResponse> getDirect() {
        return get(Optional.empty());
    }

    /**
     * Get account details
     * 
     * <p>
 * <br>
 * <br>Get current account balance and other details of your account. You can check also account limit and if account is main one. Main accounts have unlimited privileges and using <a href="https://panel.szybkisms.pl">User Panel</a> you can create as many subaccounts as you need.
 * <br>
 * <br>This method doesn't take any parameters. As a successful result a details of current account you are logged in using an API Access Token will be returned.
     * 
     * @param options additional options
     * @return CompletableFuture&lt;GetAccountDetailsResponse&gt; - The async response
     */
    public CompletableFuture<GetAccountDetailsResponse> get(Optional<Options> options) {
        AsyncRequestlessOperation<GetAccountDetailsResponse> operation
            = new GetAccountDetails.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest()
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get subaccount details
     * 
     * <p>
 * <br>
 * <br>Check account balance and other details such subcredit balance of a subaccount. Subaccounts are additional users who can access your account services and the details. You can restrict access level and setup privileges to subaccounts using <a href="https://panel.szybkisms.pl">User Panel</a>.
 * <br>
 * <br>You should pass the subaccount user login to access its data. Please use builder style: 
 * <br>
     * <pre><code>
     * GetSubaccountDetailsResponse res = sdk.accounts().getSubaccount()
     *    .userLogin("some-login")
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result the details of subaccount with provided login will be returned.
     * 
     * @return The async call builder
     */
    public GetSubaccountDetailsRequestBuilder getSubaccount() {
        return new GetSubaccountDetailsRequestBuilder(sdkConfiguration);
    }

    /**
     * Get subaccount details
     * 
     * <p>
 * <br>
 * <br>Check account balance and other details such subcredit balance of a subaccount. Subaccounts are additional users who can access your account services and the details. You can restrict access level and setup privileges to subaccounts using <a href="https://panel.szybkisms.pl">User Panel</a>.
 * <br>
 * <br>You should pass the subaccount user login to access its data. Please use builder style: 
 * <br>
     * <pre><code>
     * GetSubaccountDetailsResponse res = sdk.accounts().getSubaccount()
     *    .userLogin("some-login")
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result the details of subaccount with provided login will be returned.
     * 
     * @param userLogin Login of the subaccount (user) to get the data for
     * @return CompletableFuture&lt;GetSubaccountDetailsResponse&gt; - The async response
     */
    public CompletableFuture<GetSubaccountDetailsResponse> getSubaccount(String userLogin) {
        return getSubaccount(userLogin, Optional.empty());
    }

    /**
     * Get subaccount details
     * 
     * <p>
 * <br>
 * <br>Check account balance and other details such subcredit balance of a subaccount. Subaccounts are additional users who can access your account services and the details. You can restrict access level and setup privileges to subaccounts using <a href="https://panel.szybkisms.pl">User Panel</a>.
 * <br>
 * <br>You should pass the subaccount user login to access its data. Please use builder style: 
 * <br>
     * <pre><code>
     * GetSubaccountDetailsResponse res = sdk.accounts().getSubaccount()
     *    .userLogin("some-login")
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result the details of subaccount with provided login will be returned.
     * 
     * @param userLogin Login of the subaccount (user) to get the data for
     * @param options additional options
     * @return CompletableFuture&lt;GetSubaccountDetailsResponse&gt; - The async response
     */
    public CompletableFuture<GetSubaccountDetailsResponse> getSubaccount(String userLogin, Optional<Options> options) {
        GetSubaccountDetailsRequest request =
            GetSubaccountDetailsRequest
                .builder()
                .userLogin(userLogin)
                .build();
        AsyncRequestOperation<GetSubaccountDetailsRequest, GetSubaccountDetailsResponse> operation
              = new GetSubaccountDetails.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

}
