/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway;

import pl.gsmservice.gateway.utils.Headers;

/**
 * Messaging Gateway SzybkiSMS.pl (former GSMService.pl): 
 * <br>
 * <br>This package includes Messaging SDK for JAVA to send SMS &amp; MMS messages directly from your app via <a href="https://szybkisms.pl">https://szybkisms.pl</a> messaging platform.
 * <br>
 * <br><em>Client</em> class is used to initialize SDK environment.
 * <br>
 * <br>Please initialize it this way:
 * <br>
 * <pre><code>
 * import java.lang.Exception;
 * import pl.gsmservice.gateway.Client;
 * import pl.gsmservice.gateway.models.errors.ErrorResponse;
 * 
 * <p>Client sdk = Client.builder()
 *    .bearer("&lt;YOUR API ACCESS TOKEN&gt;")
 *    .build();
 * </code></pre>
 * 
 * <br>If you want to use a Sandbox test system please initialize it as follows:
 * <br>
 * <pre><code>
 * Client sdk = Client.builder()
 *    .server(Client.AvailableServers.SANDBOX)
 *    .bearer("&lt;YOUR API ACCESS TOKEN&gt;")
 *    .build();
 * </code></pre>
 */
public class AsyncClient {
    private static final Headers _headers = Headers.EMPTY;

    private final AsyncAccounts accounts;

    private final AsyncOutgoing outgoing;

    private final AsyncIncoming incoming;

    private final AsyncCommon common;

    private final AsyncSenders senders;

    public AsyncAccounts accounts() {
        return accounts;
    }

    public AsyncOutgoing outgoing() {
        return outgoing;
    }

    public AsyncIncoming incoming() {
        return incoming;
    }

    public AsyncCommon common() {
        return common;
    }

    public AsyncSenders senders() {
        return senders;
    }

    private final SDKConfiguration sdkConfiguration;
    private final Client syncSDK;

    AsyncClient(Client syncSDK, SDKConfiguration sdkConfiguration) {
        this.syncSDK = syncSDK;
        this.sdkConfiguration = sdkConfiguration;
        this.accounts = new AsyncAccounts(syncSDK.accounts(), sdkConfiguration);
        this.outgoing = new AsyncOutgoing(syncSDK.outgoing(), sdkConfiguration);
        this.incoming = new AsyncIncoming(syncSDK.incoming(), sdkConfiguration);
        this.common = new AsyncCommon(syncSDK.common(), sdkConfiguration);
        this.senders = new AsyncSenders(syncSDK.senders(), sdkConfiguration);
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public Client sync() {
        return syncSDK;
    }
}
