/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway;

import static pl.gsmservice.gateway.operations.Operations.AsyncRequestlessOperation;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.gsmservice.gateway.models.operations.async.PingRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.PingResponse;
import pl.gsmservice.gateway.operations.Ping;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;


public class AsyncCommon {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Common syncSDK;

    AsyncCommon(Common syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public Common sync() {
        return syncSDK;
    }


    /**
     * Checks API availability and version
     * 
     * <p>
 * <br>
 * <br>Check the API connection and the current API availability status. Also you will get the current API version number. The method doesn't accept any parameters. Please use builder style:
 * <br>
     * <pre><code>
     * PingResponse res = sdk.common().ping()
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result a <code>PingResponse</code> object will be returned.
     * 
     * @return The async call builder
     */
    public PingRequestBuilder ping() {
        return new PingRequestBuilder(sdkConfiguration);
    }

    /**
     * Checks API availability and version
     * 
     * <p>
 * <br>
 * <br>Check the API connection and the current API availability status. Also you will get the current API version number. The method doesn't accept any parameters. Please use builder style:
 * <br>
     * <pre><code>
     * PingResponse res = sdk.common().ping()
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result a <code>PingResponse</code> object will be returned.
     * 
     * @return CompletableFuture&lt;PingResponse&gt; - The async response
     */
    public CompletableFuture<PingResponse> pingDirect() {
        return ping(Optional.empty());
    }

    /**
     * Checks API availability and version
     * 
     * <p>
 * <br>
 * <br>Check the API connection and the current API availability status. Also you will get the current API version number. The method doesn't accept any parameters. Please use builder style:
 * <br>
     * <pre><code>
     * PingResponse res = sdk.common().ping()
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result a <code>PingResponse</code> object will be returned.
     * 
     * @param options additional options
     * @return CompletableFuture&lt;PingResponse&gt; - The async response
     */
    public CompletableFuture<PingResponse> ping(Optional<Options> options) {
        AsyncRequestlessOperation<PingResponse> operation
            = new Ping.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest()
            .thenCompose(operation::handleResponse);
    }

}
