/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway;

import static pl.gsmservice.gateway.operations.Operations.AsyncRequestOperation;

import java.lang.Long;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.gsmservice.gateway.models.operations.GetIncomingMessagesRequest;
import pl.gsmservice.gateway.models.operations.ListIncomingMessagesRequest;
import pl.gsmservice.gateway.models.operations.async.GetIncomingMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.GetIncomingMessagesResponse;
import pl.gsmservice.gateway.models.operations.async.ListIncomingMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.ListIncomingMessagesResponse;
import pl.gsmservice.gateway.operations.GetIncomingMessages;
import pl.gsmservice.gateway.operations.ListIncomingMessages;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;


public class AsyncIncoming {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Incoming syncSDK;

    AsyncIncoming(Incoming syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public Incoming sync() {
        return syncSDK;
    }


    /**
     * List the received SMS messages
     * 
     * <p>
 * <br>
 * <br>Get the details of all received messages from your account incoming messages box. This method supports pagination so you have to pass <code>page</code> (number of page with received messages which you want to access, <code>Long</code> type) and a <code>limit</code> (max of received messages per page, <code>Long</code> type) parameters. Please use builder style:
 * <br>
     * <pre><code>
     * ListIncomingMessagesResponse res = sdk.incoming().list()
     *    .page(1L)
     *    .limit(10L)
     *    .call();
     * </code></pre>
     * 
 * <br>Messages are fetched from the latest one. This method will accept maximum <strong>50</strong> as <code>limit</code> parameter value.
 * <br>
 * <br>As a successful result a <code>ListIncomingMessagesResponse</code> object will be returned with <code>incomingMessages</code> property of type <code>List&lt;IncomingMessage&gt;</code> containing <code>IncomingMessage</code> objects, each object per single received message.
 * <br>
 * <br><code>ListIncomingMessagesResponse</code> object will contain also a <code>headers</code> property where you can find <code>X-Total-Results</code> (a total count of all received messages which are available in incoming box on your account), <code>X-Total-Pages</code> (a total number of all pages with results), <code>X-Current-Page</code> (A current page number) and <code>X-Limit</code> (messages count per single page) elements.
     * 
     * @return The async call builder
     */
    public ListIncomingMessagesRequestBuilder list() {
        return new ListIncomingMessagesRequestBuilder(sdkConfiguration);
    }

    /**
     * List the received SMS messages
     * 
     * <p>
 * <br>
 * <br>Get the details of all received messages from your account incoming messages box. This method supports pagination so you have to pass <code>page</code> (number of page with received messages which you want to access, <code>Long</code> type) and a <code>limit</code> (max of received messages per page, <code>Long</code> type) parameters. Please use builder style:
 * <br>
     * <pre><code>
     * ListIncomingMessagesResponse res = sdk.incoming().list()
     *    .page(1L)
     *    .limit(10L)
     *    .call();
     * </code></pre>
     * 
 * <br>Messages are fetched from the latest one. This method will accept maximum <strong>50</strong> as <code>limit</code> parameter value.
 * <br>
 * <br>As a successful result a <code>ListIncomingMessagesResponse</code> object will be returned with <code>incomingMessages</code> property of type <code>List&lt;IncomingMessage&gt;</code> containing <code>IncomingMessage</code> objects, each object per single received message.
 * <br>
 * <br><code>ListIncomingMessagesResponse</code> object will contain also a <code>headers</code> property where you can find <code>X-Total-Results</code> (a total count of all received messages which are available in incoming box on your account), <code>X-Total-Pages</code> (a total number of all pages with results), <code>X-Current-Page</code> (A current page number) and <code>X-Limit</code> (messages count per single page) elements.
     * 
     * @return CompletableFuture&lt;ListIncomingMessagesResponse&gt; - The async response
     */
    public CompletableFuture<ListIncomingMessagesResponse> listDirect() {
        return list(Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * List the received SMS messages
     * 
     * <p>
 * <br>
 * <br>Get the details of all received messages from your account incoming messages box. This method supports pagination so you have to pass <code>page</code> (number of page with received messages which you want to access, <code>Long</code> type) and a <code>limit</code> (max of received messages per page, <code>Long</code> type) parameters. Please use builder style:
 * <br>
     * <pre><code>
     * ListIncomingMessagesResponse res = sdk.incoming().list()
     *    .page(1L)
     *    .limit(10L)
     *    .call();
     * </code></pre>
     * 
 * <br>Messages are fetched from the latest one. This method will accept maximum <strong>50</strong> as <code>limit</code> parameter value.
 * <br>
 * <br>As a successful result a <code>ListIncomingMessagesResponse</code> object will be returned with <code>incomingMessages</code> property of type <code>List&lt;IncomingMessage&gt;</code> containing <code>IncomingMessage</code> objects, each object per single received message.
 * <br>
 * <br><code>ListIncomingMessagesResponse</code> object will contain also a <code>headers</code> property where you can find <code>X-Total-Results</code> (a total count of all received messages which are available in incoming box on your account), <code>X-Total-Pages</code> (a total number of all pages with results), <code>X-Current-Page</code> (A current page number) and <code>X-Limit</code> (messages count per single page) elements.
     * 
     * @param page Page number of results
     * @param limit Number of results on one page
     * @param options additional options
     * @return CompletableFuture&lt;ListIncomingMessagesResponse&gt; - The async response
     */
    public CompletableFuture<ListIncomingMessagesResponse> list(
            Optional<Long> page, Optional<Long> limit,
            Optional<Options> options) {
        ListIncomingMessagesRequest request =
            ListIncomingMessagesRequest
                .builder()
                .page(page)
                .limit(limit)
                .build();
        AsyncRequestOperation<ListIncomingMessagesRequest, ListIncomingMessagesResponse> operation
              = new ListIncomingMessages.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get the incoming messages by IDs
     * 
     * <p>
 * <br>
 * <br>Get the details of one or more received messages using their <code>ids</code>. You should pass the ListOf() containing unique incoming message IDs (Long type) which details you want to fetch. Please use builder style:
 * <br>
     * <pre><code>
     * GetIncomingMessagesResponse res = sdk.incoming().getByIds()
     *    .ids(List.of(43456L))
     *    .call();
     * </code></pre>
     * 
 * <br>The method will accept maximum 50 identifiers in one call.
 * <br>
 * <br>As a successful result a <code>GetIncomingMessagesResponse</code> object will be returned with an <code>incomingMessages</code> property of type <code>List&lt;IncomingMessage&gt;</code> containing <code>IncomingMessage</code> objects, each object per single received message.
 * <br>
 * <br><code>GetIncomingMessagesResponse</code> object will contain also a <code>headers</code> property where you can find <code>X-Success-Count</code> (a count of incoming messages which were found and returned correctly) and <code>X-Error-Count</code> (count of incoming messages which were not found) elements.
     * 
     * @return The async call builder
     */
    public GetIncomingMessagesRequestBuilder getByIds() {
        return new GetIncomingMessagesRequestBuilder(sdkConfiguration);
    }

    /**
     * Get the incoming messages by IDs
     * 
     * <p>
 * <br>
 * <br>Get the details of one or more received messages using their <code>ids</code>. You should pass the ListOf() containing unique incoming message IDs (Long type) which details you want to fetch. Please use builder style:
 * <br>
     * <pre><code>
     * GetIncomingMessagesResponse res = sdk.incoming().getByIds()
     *    .ids(List.of(43456L))
     *    .call();
     * </code></pre>
     * 
 * <br>The method will accept maximum 50 identifiers in one call.
 * <br>
 * <br>As a successful result a <code>GetIncomingMessagesResponse</code> object will be returned with an <code>incomingMessages</code> property of type <code>List&lt;IncomingMessage&gt;</code> containing <code>IncomingMessage</code> objects, each object per single received message.
 * <br>
 * <br><code>GetIncomingMessagesResponse</code> object will contain also a <code>headers</code> property where you can find <code>X-Success-Count</code> (a count of incoming messages which were found and returned correctly) and <code>X-Error-Count</code> (count of incoming messages which were not found) elements.
     * 
     * @param ids List<Long> of Message IDs assigned by the system. The system will accept a maximum of 50 identifiers in one call.
     * @return CompletableFuture&lt;GetIncomingMessagesResponse&gt; - The async response
     */
    public CompletableFuture<GetIncomingMessagesResponse> getByIds(List<Long> ids) {
        return getByIds(ids, Optional.empty());
    }

    /**
     * Get the incoming messages by IDs
     * 
     * <p>
 * <br>
 * <br>Get the details of one or more received messages using their <code>ids</code>. You should pass the ListOf() containing unique incoming message IDs (Long type) which details you want to fetch. Please use builder style:
 * <br>
     * <pre><code>
     * GetIncomingMessagesResponse res = sdk.incoming().getByIds()
     *    .ids(List.of(43456L))
     *    .call();
     * </code></pre>
     * 
 * <br>The method will accept maximum 50 identifiers in one call.
 * <br>
 * <br>As a successful result a <code>GetIncomingMessagesResponse</code> object will be returned with an <code>incomingMessages</code> property of type <code>List&lt;IncomingMessage&gt;</code> containing <code>IncomingMessage</code> objects, each object per single received message.
 * <br>
 * <br><code>GetIncomingMessagesResponse</code> object will contain also a <code>headers</code> property where you can find <code>X-Success-Count</code> (a count of incoming messages which were found and returned correctly) and <code>X-Error-Count</code> (count of incoming messages which were not found) elements.
     * 
     * @param ids List<Long> of Message IDs assigned by the system. The system will accept a maximum of 50 identifiers in one call.
     * @param options additional options
     * @return CompletableFuture&lt;GetIncomingMessagesResponse&gt; - The async response
     */
    public CompletableFuture<GetIncomingMessagesResponse> getByIds(List<Long> ids, Optional<Options> options) {
        GetIncomingMessagesRequest request =
            GetIncomingMessagesRequest
                .builder()
                .ids(ids)
                .build();
        AsyncRequestOperation<GetIncomingMessagesRequest, GetIncomingMessagesResponse> operation
              = new GetIncomingMessages.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

}
