/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway;

import static pl.gsmservice.gateway.operations.Operations.AsyncRequestlessOperation;
import static pl.gsmservice.gateway.operations.Operations.AsyncRequestOperation;

import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.gsmservice.gateway.models.components.SenderInput;
import pl.gsmservice.gateway.models.operations.DeleteSenderRequest;
import pl.gsmservice.gateway.models.operations.SetDefaultSenderRequest;
import pl.gsmservice.gateway.models.operations.async.AddSenderRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.AddSenderResponse;
import pl.gsmservice.gateway.models.operations.async.DeleteSenderRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.DeleteSenderResponse;
import pl.gsmservice.gateway.models.operations.async.ListSendersRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.ListSendersResponse;
import pl.gsmservice.gateway.models.operations.async.SetDefaultSenderRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.SetDefaultSenderResponse;
import pl.gsmservice.gateway.operations.AddSender;
import pl.gsmservice.gateway.operations.DeleteSender;
import pl.gsmservice.gateway.operations.ListSenders;
import pl.gsmservice.gateway.operations.SetDefaultSender;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;


public class AsyncSenders {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Senders syncSDK;

    AsyncSenders(Senders syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public Senders sync() {
        return syncSDK;
    }


    /**
     * List allowed senders names
     * 
     * <p>
 * <br>
 * <br>Get a list of allowed senders defined in your account. The method doesn't take any parameters. Please use builder style:
 * <br>
     * <pre><code>
     * ListSendersResponse res = sdk.senders().list()
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result a <code>ListSendersResponse</code> object will be returned wich <code>senders</code> property of type <code>List&lt;Sender&gt;</code> containing <code>Sender</code> objects, each object per single sender.
     * 
     * @return The async call builder
     */
    public ListSendersRequestBuilder list() {
        return new ListSendersRequestBuilder(sdkConfiguration);
    }

    /**
     * List allowed senders names
     * 
     * <p>
 * <br>
 * <br>Get a list of allowed senders defined in your account. The method doesn't take any parameters. Please use builder style:
 * <br>
     * <pre><code>
     * ListSendersResponse res = sdk.senders().list()
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result a <code>ListSendersResponse</code> object will be returned wich <code>senders</code> property of type <code>List&lt;Sender&gt;</code> containing <code>Sender</code> objects, each object per single sender.
     * 
     * @return CompletableFuture&lt;ListSendersResponse&gt; - The async response
     */
    public CompletableFuture<ListSendersResponse> listDirect() {
        return list(Optional.empty());
    }

    /**
     * List allowed senders names
     * 
     * <p>
 * <br>
 * <br>Get a list of allowed senders defined in your account. The method doesn't take any parameters. Please use builder style:
 * <br>
     * <pre><code>
     * ListSendersResponse res = sdk.senders().list()
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result a <code>ListSendersResponse</code> object will be returned wich <code>senders</code> property of type <code>List&lt;Sender&gt;</code> containing <code>Sender</code> objects, each object per single sender.
     * 
     * @param options additional options
     * @return CompletableFuture&lt;ListSendersResponse&gt; - The async response
     */
    public CompletableFuture<ListSendersResponse> list(Optional<Options> options) {
        AsyncRequestlessOperation<ListSendersResponse> operation
            = new ListSenders.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest()
            .thenCompose(operation::handleResponse);
    }


    /**
     * Add a new sender name
     * 
     * <p>
 * <br>
 * <br>Define a new allowed sender on your account. You should pass as parameter a <code>SenderInput</code> object with two properties: <code>sender</code> (defines sender name) and <code>description</code>. Please use builder style:
 * <br>
     * <pre><code>
     * AddSenderResponse res = sdk.senders().add()
     *    .request(req)
     *    .call();
     * </code></pre>
     * 
 * <br>Please carefully fill this property with the extensive description of a sender name (what will be its use, what the name mean, etc). 
 * <br>
 * <br>As a successful result a <code>AddSenderResponse</code> object will be returned with a <code>sender</code> property containing a <code>Sender</code> object with details and status of added sender name.
     * 
     * @return The async call builder
     */
    public AddSenderRequestBuilder add() {
        return new AddSenderRequestBuilder(sdkConfiguration);
    }

    /**
     * Add a new sender name
     * 
     * <p>
 * <br>
 * <br>Define a new allowed sender on your account. You should pass as parameter a <code>SenderInput</code> object with two properties: <code>sender</code> (defines sender name) and <code>description</code>. Please use builder style:
 * <br>
     * <pre><code>
     * AddSenderResponse res = sdk.senders().add()
     *    .request(req)
     *    .call();
     * </code></pre>
     * 
 * <br>Please carefully fill this property with the extensive description of a sender name (what will be its use, what the name mean, etc). 
 * <br>
 * <br>As a successful result a <code>AddSenderResponse</code> object will be returned with a <code>sender</code> property containing a <code>Sender</code> object with details and status of added sender name.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;AddSenderResponse&gt; - The async response
     */
    public CompletableFuture<AddSenderResponse> add(SenderInput request) {
        return add(request, Optional.empty());
    }

    /**
     * Add a new sender name
     * 
     * <p>
 * <br>
 * <br>Define a new allowed sender on your account. You should pass as parameter a <code>SenderInput</code> object with two properties: <code>sender</code> (defines sender name) and <code>description</code>. Please use builder style:
 * <br>
     * <pre><code>
     * AddSenderResponse res = sdk.senders().add()
     *    .request(req)
     *    .call();
     * </code></pre>
     * 
 * <br>Please carefully fill this property with the extensive description of a sender name (what will be its use, what the name mean, etc). 
 * <br>
 * <br>As a successful result a <code>AddSenderResponse</code> object will be returned with a <code>sender</code> property containing a <code>Sender</code> object with details and status of added sender name.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;AddSenderResponse&gt; - The async response
     */
    public CompletableFuture<AddSenderResponse> add(SenderInput request, Optional<Options> options) {
        AsyncRequestOperation<SenderInput, AddSenderResponse> operation
              = new AddSender.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Delete a sender name
     * 
     * <p>
 * <br>
 * <br>Removes defined sender name from your account. This method accepts a <code>string</code> with a <strong>sender name</strong> you want to remove. Please use builder style:
 * <br>
     * <pre><code>
     * DeleteSenderResponse res = sdk.senders().delete()
     *    .sender("Podpis")
     *    .call();
     * </code></pre>
     * 
 * <br>Sender name will be deleted immediately.
 * <br>
 * <br>As a successful response a <code>DeleteSenderResponse</code> object will de returned with <code>statusCode</code> property of <code>204</code>.
     * 
     * @return The async call builder
     */
    public DeleteSenderRequestBuilder delete() {
        return new DeleteSenderRequestBuilder(sdkConfiguration);
    }

    /**
     * Delete a sender name
     * 
     * <p>
 * <br>
 * <br>Removes defined sender name from your account. This method accepts a <code>string</code> with a <strong>sender name</strong> you want to remove. Please use builder style:
 * <br>
     * <pre><code>
     * DeleteSenderResponse res = sdk.senders().delete()
     *    .sender("Podpis")
     *    .call();
     * </code></pre>
     * 
 * <br>Sender name will be deleted immediately.
 * <br>
 * <br>As a successful response a <code>DeleteSenderResponse</code> object will de returned with <code>statusCode</code> property of <code>204</code>.
     * 
     * @param sender Sender name to be removed
     * @return CompletableFuture&lt;DeleteSenderResponse&gt; - The async response
     */
    public CompletableFuture<DeleteSenderResponse> delete(String sender) {
        return delete(sender, Optional.empty());
    }

    /**
     * Delete a sender name
     * 
     * <p>
 * <br>
 * <br>Removes defined sender name from your account. This method accepts a <code>string</code> with a <strong>sender name</strong> you want to remove. Please use builder style:
 * <br>
     * <pre><code>
     * DeleteSenderResponse res = sdk.senders().delete()
     *    .sender("Podpis")
     *    .call();
     * </code></pre>
     * 
 * <br>Sender name will be deleted immediately.
 * <br>
 * <br>As a successful response a <code>DeleteSenderResponse</code> object will de returned with <code>statusCode</code> property of <code>204</code>.
     * 
     * @param sender Sender name to be removed
     * @param options additional options
     * @return CompletableFuture&lt;DeleteSenderResponse&gt; - The async response
     */
    public CompletableFuture<DeleteSenderResponse> delete(String sender, Optional<Options> options) {
        DeleteSenderRequest request =
            DeleteSenderRequest
                .builder()
                .sender(sender)
                .build();
        AsyncRequestOperation<DeleteSenderRequest, DeleteSenderResponse> operation
              = new DeleteSender.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Set default sender name
     * 
     * <p>
 * <br>
 * <br>Set default sender name to one of the senders names already defined on your account. This method accepts a <code>string</code> containing a <strong>sender name</strong> to be set as default on your account. Please use a builder style:
 * <br>
     * <pre><code>
     * SetDefaultSenderResponse res = sdk.senders().setDefault()
     *    .sender("Podpis")
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful response a <code>SetDefaultSenderResponse</code> will be returned with <code>statusCode</code> property of <code>204</code>.
     * 
     * @return The async call builder
     */
    public SetDefaultSenderRequestBuilder setDefault() {
        return new SetDefaultSenderRequestBuilder(sdkConfiguration);
    }

    /**
     * Set default sender name
     * 
     * <p>
 * <br>
 * <br>Set default sender name to one of the senders names already defined on your account. This method accepts a <code>string</code> containing a <strong>sender name</strong> to be set as default on your account. Please use a builder style:
 * <br>
     * <pre><code>
     * SetDefaultSenderResponse res = sdk.senders().setDefault()
     *    .sender("Podpis")
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful response a <code>SetDefaultSenderResponse</code> will be returned with <code>statusCode</code> property of <code>204</code>.
     * 
     * @param sender Sender name to set as default
     * @return CompletableFuture&lt;SetDefaultSenderResponse&gt; - The async response
     */
    public CompletableFuture<SetDefaultSenderResponse> setDefault(String sender) {
        return setDefault(sender, Optional.empty());
    }

    /**
     * Set default sender name
     * 
     * <p>
 * <br>
 * <br>Set default sender name to one of the senders names already defined on your account. This method accepts a <code>string</code> containing a <strong>sender name</strong> to be set as default on your account. Please use a builder style:
 * <br>
     * <pre><code>
     * SetDefaultSenderResponse res = sdk.senders().setDefault()
     *    .sender("Podpis")
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful response a <code>SetDefaultSenderResponse</code> will be returned with <code>statusCode</code> property of <code>204</code>.
     * 
     * @param sender Sender name to set as default
     * @param options additional options
     * @return CompletableFuture&lt;SetDefaultSenderResponse&gt; - The async response
     */
    public CompletableFuture<SetDefaultSenderResponse> setDefault(String sender, Optional<Options> options) {
        SetDefaultSenderRequest request =
            SetDefaultSenderRequest
                .builder()
                .sender(sender)
                .build();
        AsyncRequestOperation<SetDefaultSenderRequest, SetDefaultSenderResponse> operation
              = new SetDefaultSender.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

}
