/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway;

import static pl.gsmservice.gateway.operations.Operations.RequestlessOperation;

import java.lang.Exception;
import java.util.Optional;
import pl.gsmservice.gateway.models.operations.PingRequestBuilder;
import pl.gsmservice.gateway.models.operations.PingResponse;
import pl.gsmservice.gateway.operations.Ping;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;


public class Common {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncCommon asyncSDK;

    Common(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncCommon(this, sdkConfiguration);
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncCommon async() {
        return asyncSDK;
    }

    /**
     * Checks API availability and version
     * 
     * <p>
 * <br>
 * <br>Check the API connection and the current API availability status. Also you will get the current API version number. The method doesn't accept any parameters. Please use builder style:
 * <br>
     * <pre><code>
     * PingResponse res = sdk.common().ping()
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result a <code>PingResponse</code> object will be returned.
     * 
     * @return The call builder
     */
    public PingRequestBuilder ping() {
        return new PingRequestBuilder(sdkConfiguration);
    }

    /**
     * Checks API availability and version
     * 
     * <p>
 * <br>
 * <br>Check the API connection and the current API availability status. Also you will get the current API version number. The method doesn't accept any parameters. Please use builder style:
 * <br>
     * <pre><code>
     * PingResponse res = sdk.common().ping()
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result a <code>PingResponse</code> object will be returned.
     * 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public PingResponse pingDirect() throws Exception {
        return ping(Optional.empty());
    }

    /**
     * Checks API availability and version
     * 
     * <p>
 * <br>
 * <br>Check the API connection and the current API availability status. Also you will get the current API version number. The method doesn't accept any parameters. Please use builder style:
 * <br>
     * <pre><code>
     * PingResponse res = sdk.common().ping()
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result a <code>PingResponse</code> object will be returned.
     * 
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public PingResponse ping(Optional<Options> options) throws Exception {
        RequestlessOperation<PingResponse> operation
            = new Ping.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest());
    }

}
