/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway;

import static pl.gsmservice.gateway.operations.Operations.RequestOperation;

import java.lang.Exception;
import java.lang.Long;
import java.util.List;
import java.util.Optional;
import pl.gsmservice.gateway.models.operations.GetIncomingMessagesRequest;
import pl.gsmservice.gateway.models.operations.GetIncomingMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.GetIncomingMessagesResponse;
import pl.gsmservice.gateway.models.operations.ListIncomingMessagesRequest;
import pl.gsmservice.gateway.models.operations.ListIncomingMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.ListIncomingMessagesResponse;
import pl.gsmservice.gateway.operations.GetIncomingMessages;
import pl.gsmservice.gateway.operations.ListIncomingMessages;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;


public class Incoming {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncIncoming asyncSDK;

    Incoming(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncIncoming(this, sdkConfiguration);
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncIncoming async() {
        return asyncSDK;
    }

    /**
     * List the received SMS messages
     * 
     * <p>
 * <br>
 * <br>Get the details of all received messages from your account incoming messages box. This method supports pagination so you have to pass <code>page</code> (number of page with received messages which you want to access, <code>Long</code> type) and a <code>limit</code> (max of received messages per page, <code>Long</code> type) parameters. Please use builder style:
 * <br>
     * <pre><code>
     * ListIncomingMessagesResponse res = sdk.incoming().list()
     *    .page(1L)
     *    .limit(10L)
     *    .call();
     * </code></pre>
     * 
 * <br>Messages are fetched from the latest one. This method will accept maximum <strong>50</strong> as <code>limit</code> parameter value.
 * <br>
 * <br>As a successful result a <code>ListIncomingMessagesResponse</code> object will be returned with <code>incomingMessages</code> property of type <code>List&lt;IncomingMessage&gt;</code> containing <code>IncomingMessage</code> objects, each object per single received message.
 * <br>
 * <br><code>ListIncomingMessagesResponse</code> object will contain also a <code>headers</code> property where you can find <code>X-Total-Results</code> (a total count of all received messages which are available in incoming box on your account), <code>X-Total-Pages</code> (a total number of all pages with results), <code>X-Current-Page</code> (A current page number) and <code>X-Limit</code> (messages count per single page) elements.
     * 
     * @return The call builder
     */
    public ListIncomingMessagesRequestBuilder list() {
        return new ListIncomingMessagesRequestBuilder(sdkConfiguration);
    }

    /**
     * List the received SMS messages
     * 
     * <p>
 * <br>
 * <br>Get the details of all received messages from your account incoming messages box. This method supports pagination so you have to pass <code>page</code> (number of page with received messages which you want to access, <code>Long</code> type) and a <code>limit</code> (max of received messages per page, <code>Long</code> type) parameters. Please use builder style:
 * <br>
     * <pre><code>
     * ListIncomingMessagesResponse res = sdk.incoming().list()
     *    .page(1L)
     *    .limit(10L)
     *    .call();
     * </code></pre>
     * 
 * <br>Messages are fetched from the latest one. This method will accept maximum <strong>50</strong> as <code>limit</code> parameter value.
 * <br>
 * <br>As a successful result a <code>ListIncomingMessagesResponse</code> object will be returned with <code>incomingMessages</code> property of type <code>List&lt;IncomingMessage&gt;</code> containing <code>IncomingMessage</code> objects, each object per single received message.
 * <br>
 * <br><code>ListIncomingMessagesResponse</code> object will contain also a <code>headers</code> property where you can find <code>X-Total-Results</code> (a total count of all received messages which are available in incoming box on your account), <code>X-Total-Pages</code> (a total number of all pages with results), <code>X-Current-Page</code> (A current page number) and <code>X-Limit</code> (messages count per single page) elements.
     * 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListIncomingMessagesResponse listDirect() throws Exception {
        return list(Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * List the received SMS messages
     * 
     * <p>
 * <br>
 * <br>Get the details of all received messages from your account incoming messages box. This method supports pagination so you have to pass <code>page</code> (number of page with received messages which you want to access, <code>Long</code> type) and a <code>limit</code> (max of received messages per page, <code>Long</code> type) parameters. Please use builder style:
 * <br>
     * <pre><code>
     * ListIncomingMessagesResponse res = sdk.incoming().list()
     *    .page(1L)
     *    .limit(10L)
     *    .call();
     * </code></pre>
     * 
 * <br>Messages are fetched from the latest one. This method will accept maximum <strong>50</strong> as <code>limit</code> parameter value.
 * <br>
 * <br>As a successful result a <code>ListIncomingMessagesResponse</code> object will be returned with <code>incomingMessages</code> property of type <code>List&lt;IncomingMessage&gt;</code> containing <code>IncomingMessage</code> objects, each object per single received message.
 * <br>
 * <br><code>ListIncomingMessagesResponse</code> object will contain also a <code>headers</code> property where you can find <code>X-Total-Results</code> (a total count of all received messages which are available in incoming box on your account), <code>X-Total-Pages</code> (a total number of all pages with results), <code>X-Current-Page</code> (A current page number) and <code>X-Limit</code> (messages count per single page) elements.
     * 
     * @param page Page number of results
     * @param limit Number of results on one page
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListIncomingMessagesResponse list(
            Optional<Long> page, Optional<Long> limit,
            Optional<Options> options) throws Exception {
        ListIncomingMessagesRequest request =
            ListIncomingMessagesRequest
                .builder()
                .page(page)
                .limit(limit)
                .build();
        RequestOperation<ListIncomingMessagesRequest, ListIncomingMessagesResponse> operation
              = new ListIncomingMessages.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get the incoming messages by IDs
     * 
     * <p>
 * <br>
 * <br>Get the details of one or more received messages using their <code>ids</code>. You should pass the ListOf() containing unique incoming message IDs (Long type) which details you want to fetch. Please use builder style:
 * <br>
     * <pre><code>
     * GetIncomingMessagesResponse res = sdk.incoming().getByIds()
     *    .ids(List.of(43456L))
     *    .call();
     * </code></pre>
     * 
 * <br>The method will accept maximum 50 identifiers in one call.
 * <br>
 * <br>As a successful result a <code>GetIncomingMessagesResponse</code> object will be returned with an <code>incomingMessages</code> property of type <code>List&lt;IncomingMessage&gt;</code> containing <code>IncomingMessage</code> objects, each object per single received message.
 * <br>
 * <br><code>GetIncomingMessagesResponse</code> object will contain also a <code>headers</code> property where you can find <code>X-Success-Count</code> (a count of incoming messages which were found and returned correctly) and <code>X-Error-Count</code> (count of incoming messages which were not found) elements.
     * 
     * @return The call builder
     */
    public GetIncomingMessagesRequestBuilder getByIds() {
        return new GetIncomingMessagesRequestBuilder(sdkConfiguration);
    }

    /**
     * Get the incoming messages by IDs
     * 
     * <p>
 * <br>
 * <br>Get the details of one or more received messages using their <code>ids</code>. You should pass the ListOf() containing unique incoming message IDs (Long type) which details you want to fetch. Please use builder style:
 * <br>
     * <pre><code>
     * GetIncomingMessagesResponse res = sdk.incoming().getByIds()
     *    .ids(List.of(43456L))
     *    .call();
     * </code></pre>
     * 
 * <br>The method will accept maximum 50 identifiers in one call.
 * <br>
 * <br>As a successful result a <code>GetIncomingMessagesResponse</code> object will be returned with an <code>incomingMessages</code> property of type <code>List&lt;IncomingMessage&gt;</code> containing <code>IncomingMessage</code> objects, each object per single received message.
 * <br>
 * <br><code>GetIncomingMessagesResponse</code> object will contain also a <code>headers</code> property where you can find <code>X-Success-Count</code> (a count of incoming messages which were found and returned correctly) and <code>X-Error-Count</code> (count of incoming messages which were not found) elements.
     * 
     * @param ids List<Long> of Message IDs assigned by the system. The system will accept a maximum of 50 identifiers in one call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetIncomingMessagesResponse getByIds(List<Long> ids) throws Exception {
        return getByIds(ids, Optional.empty());
    }

    /**
     * Get the incoming messages by IDs
     * 
     * <p>
 * <br>
 * <br>Get the details of one or more received messages using their <code>ids</code>. You should pass the ListOf() containing unique incoming message IDs (Long type) which details you want to fetch. Please use builder style:
 * <br>
     * <pre><code>
     * GetIncomingMessagesResponse res = sdk.incoming().getByIds()
     *    .ids(List.of(43456L))
     *    .call();
     * </code></pre>
     * 
 * <br>The method will accept maximum 50 identifiers in one call.
 * <br>
 * <br>As a successful result a <code>GetIncomingMessagesResponse</code> object will be returned with an <code>incomingMessages</code> property of type <code>List&lt;IncomingMessage&gt;</code> containing <code>IncomingMessage</code> objects, each object per single received message.
 * <br>
 * <br><code>GetIncomingMessagesResponse</code> object will contain also a <code>headers</code> property where you can find <code>X-Success-Count</code> (a count of incoming messages which were found and returned correctly) and <code>X-Error-Count</code> (count of incoming messages which were not found) elements.
     * 
     * @param ids List<Long> of Message IDs assigned by the system. The system will accept a maximum of 50 identifiers in one call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetIncomingMessagesResponse getByIds(List<Long> ids, Optional<Options> options) throws Exception {
        GetIncomingMessagesRequest request =
            GetIncomingMessagesRequest
                .builder()
                .ids(ids)
                .build();
        RequestOperation<GetIncomingMessagesRequest, GetIncomingMessagesResponse> operation
              = new GetIncomingMessages.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

}
