/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway;

import static pl.gsmservice.gateway.operations.Operations.RequestOperation;

import java.lang.Exception;
import java.util.Optional;
import pl.gsmservice.gateway.models.operations.GetMmsPriceRequestBody;
import pl.gsmservice.gateway.models.operations.GetMmsPriceRequestBuilder;
import pl.gsmservice.gateway.models.operations.GetMmsPriceResponse;
import pl.gsmservice.gateway.models.operations.SendMmsRequestBody;
import pl.gsmservice.gateway.models.operations.SendMmsRequestBuilder;
import pl.gsmservice.gateway.models.operations.SendMmsResponse;
import pl.gsmservice.gateway.operations.GetMmsPrice;
import pl.gsmservice.gateway.operations.SendMms;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;


public class Mms {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncMms asyncSDK;

    Mms(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncMms(this, sdkConfiguration);
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncMms async() {
        return asyncSDK;
    }

    /**
     * Check the price of MMS Messages
     * 
     * <p>
 * <br>
 * <br>Check the price of single or multiple MMS messages at the same time before sending them. You can pass a single <code>MmsMessage</code> object using <code>GetMmsPriceRequestBody.of(MmsMessage)</code> method (for single message) or <code>List&lt;SmsMessage&gt;</code> using <code>GetMmsPriceRequestBody.of(List.of(MmsMessage,...))</code> method (for multiple messages).
 * <br>
 * <br>Each <code>MmsMessage</code> object has several properties, describing message parameters such recipient phone number, content of the message, attachments, etc. Please use builder style:
 * <br>
     * <pre><code>
     * GetMmsPriceResponse res = sdk.outgoing().mms().getPrice()
     *    .request(req) // here pass GetMmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>The method will accept maximum <strong>50</strong> messages in one call.
 * <br>
 * <br>As a successful result a <code>GetMmsPriceResponse</code> object will be returned with <code>prices</code> property of type <code>List&lt;Price&gt;</code> containing a <code>Price</code> objects, one object per each single message. You should check the <code>error</code> property of each <code>Price</code> object to make sure which messages were priced successfully and which finished with an error. Successfully priced messages will have <code>null</code> value of <code>error</code> property.
 * <br>
 * <br><code>GetMmsPriceResponse</code> object will include also <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully) and <code>X-Error-Count</code> (count of messages which were rejected) elements.
     * 
     * @return The call builder
     */
    public GetMmsPriceRequestBuilder getPrice() {
        return new GetMmsPriceRequestBuilder(sdkConfiguration);
    }

    /**
     * Check the price of MMS Messages
     * 
     * <p>
 * <br>
 * <br>Check the price of single or multiple MMS messages at the same time before sending them. You can pass a single <code>MmsMessage</code> object using <code>GetMmsPriceRequestBody.of(MmsMessage)</code> method (for single message) or <code>List&lt;SmsMessage&gt;</code> using <code>GetMmsPriceRequestBody.of(List.of(MmsMessage,...))</code> method (for multiple messages).
 * <br>
 * <br>Each <code>MmsMessage</code> object has several properties, describing message parameters such recipient phone number, content of the message, attachments, etc. Please use builder style:
 * <br>
     * <pre><code>
     * GetMmsPriceResponse res = sdk.outgoing().mms().getPrice()
     *    .request(req) // here pass GetMmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>The method will accept maximum <strong>50</strong> messages in one call.
 * <br>
 * <br>As a successful result a <code>GetMmsPriceResponse</code> object will be returned with <code>prices</code> property of type <code>List&lt;Price&gt;</code> containing a <code>Price</code> objects, one object per each single message. You should check the <code>error</code> property of each <code>Price</code> object to make sure which messages were priced successfully and which finished with an error. Successfully priced messages will have <code>null</code> value of <code>error</code> property.
 * <br>
 * <br><code>GetMmsPriceResponse</code> object will include also <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully) and <code>X-Error-Count</code> (count of messages which were rejected) elements.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetMmsPriceResponse getPrice(GetMmsPriceRequestBody request) throws Exception {
        return getPrice(request, Optional.empty());
    }

    /**
     * Check the price of MMS Messages
     * 
     * <p>
 * <br>
 * <br>Check the price of single or multiple MMS messages at the same time before sending them. You can pass a single <code>MmsMessage</code> object using <code>GetMmsPriceRequestBody.of(MmsMessage)</code> method (for single message) or <code>List&lt;SmsMessage&gt;</code> using <code>GetMmsPriceRequestBody.of(List.of(MmsMessage,...))</code> method (for multiple messages).
 * <br>
 * <br>Each <code>MmsMessage</code> object has several properties, describing message parameters such recipient phone number, content of the message, attachments, etc. Please use builder style:
 * <br>
     * <pre><code>
     * GetMmsPriceResponse res = sdk.outgoing().mms().getPrice()
     *    .request(req) // here pass GetMmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>The method will accept maximum <strong>50</strong> messages in one call.
 * <br>
 * <br>As a successful result a <code>GetMmsPriceResponse</code> object will be returned with <code>prices</code> property of type <code>List&lt;Price&gt;</code> containing a <code>Price</code> objects, one object per each single message. You should check the <code>error</code> property of each <code>Price</code> object to make sure which messages were priced successfully and which finished with an error. Successfully priced messages will have <code>null</code> value of <code>error</code> property.
 * <br>
 * <br><code>GetMmsPriceResponse</code> object will include also <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully) and <code>X-Error-Count</code> (count of messages which were rejected) elements.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetMmsPriceResponse getPrice(GetMmsPriceRequestBody request, Optional<Options> options) throws Exception {
        RequestOperation<GetMmsPriceRequestBody, GetMmsPriceResponse> operation
              = new GetMmsPrice.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Send MMS Messages
     * 
     * <p>
 * <br>
 * <br>Send single or multiple MMS messages at the same time. You can pass a single <code>MmsMessage</code> object using <code>SendMmsRequestBody.of(MmsMessage)</code> method (for single message) or <code>List&lt;MmsMessage&gt;</code> using <code>SendMmsRequestBody.of(List.of(MmsMessage,...))</code> method (for multiple messages). Each <code>MmsMessage</code> object has several properties, describing message parameters such recipient phone number, content of the message, attachments or scheduled sending date, etc. Please use builder style:
 * <br>
     * <pre><code>
     * SendMmsResponse res = sdk.outgoing().mms().send()
     *    .request(req) // here pass GetMmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 50 messages in one call.
 * <br>
 * <br>As a successful result a <code>SendMmsResponse</code> object will be returned with <code>messages</code> property of type List&lt;Message&gt; containing <code>Message</code> objects, one object per each single message. You should check the <code>statusCode</code> property of each <code>Message</code> object to make sure which messages were accepted by gateway (queued) and which were rejected. In case of rejection, <code>statusDescription</code> property will include a reason.
 * <br>
 * <br><code>SendMmsResponse</code> will also include <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully), <code>X-Error-Count</code> (count of messages which were rejected) and <code>X-Sandbox</code> (if a request was made in Sandbox or Production system) elements.
     * 
     * @return The call builder
     */
    public SendMmsRequestBuilder send() {
        return new SendMmsRequestBuilder(sdkConfiguration);
    }

    /**
     * Send MMS Messages
     * 
     * <p>
 * <br>
 * <br>Send single or multiple MMS messages at the same time. You can pass a single <code>MmsMessage</code> object using <code>SendMmsRequestBody.of(MmsMessage)</code> method (for single message) or <code>List&lt;MmsMessage&gt;</code> using <code>SendMmsRequestBody.of(List.of(MmsMessage,...))</code> method (for multiple messages). Each <code>MmsMessage</code> object has several properties, describing message parameters such recipient phone number, content of the message, attachments or scheduled sending date, etc. Please use builder style:
 * <br>
     * <pre><code>
     * SendMmsResponse res = sdk.outgoing().mms().send()
     *    .request(req) // here pass GetMmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 50 messages in one call.
 * <br>
 * <br>As a successful result a <code>SendMmsResponse</code> object will be returned with <code>messages</code> property of type List&lt;Message&gt; containing <code>Message</code> objects, one object per each single message. You should check the <code>statusCode</code> property of each <code>Message</code> object to make sure which messages were accepted by gateway (queued) and which were rejected. In case of rejection, <code>statusDescription</code> property will include a reason.
 * <br>
 * <br><code>SendMmsResponse</code> will also include <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully), <code>X-Error-Count</code> (count of messages which were rejected) and <code>X-Sandbox</code> (if a request was made in Sandbox or Production system) elements.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public SendMmsResponse send(SendMmsRequestBody request) throws Exception {
        return send(request, Optional.empty());
    }

    /**
     * Send MMS Messages
     * 
     * <p>
 * <br>
 * <br>Send single or multiple MMS messages at the same time. You can pass a single <code>MmsMessage</code> object using <code>SendMmsRequestBody.of(MmsMessage)</code> method (for single message) or <code>List&lt;MmsMessage&gt;</code> using <code>SendMmsRequestBody.of(List.of(MmsMessage,...))</code> method (for multiple messages). Each <code>MmsMessage</code> object has several properties, describing message parameters such recipient phone number, content of the message, attachments or scheduled sending date, etc. Please use builder style:
 * <br>
     * <pre><code>
     * SendMmsResponse res = sdk.outgoing().mms().send()
     *    .request(req) // here pass GetMmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 50 messages in one call.
 * <br>
 * <br>As a successful result a <code>SendMmsResponse</code> object will be returned with <code>messages</code> property of type List&lt;Message&gt; containing <code>Message</code> objects, one object per each single message. You should check the <code>statusCode</code> property of each <code>Message</code> object to make sure which messages were accepted by gateway (queued) and which were rejected. In case of rejection, <code>statusDescription</code> property will include a reason.
 * <br>
 * <br><code>SendMmsResponse</code> will also include <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully), <code>X-Error-Count</code> (count of messages which were rejected) and <code>X-Sandbox</code> (if a request was made in Sandbox or Production system) elements.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public SendMmsResponse send(SendMmsRequestBody request, Optional<Options> options) throws Exception {
        RequestOperation<SendMmsRequestBody, SendMmsResponse> operation
              = new SendMms.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

}
