/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway;

import static pl.gsmservice.gateway.operations.Operations.RequestOperation;

import java.lang.Exception;
import java.lang.Long;
import java.util.List;
import java.util.Optional;
import pl.gsmservice.gateway.models.operations.CancelMessagesRequest;
import pl.gsmservice.gateway.models.operations.CancelMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.CancelMessagesResponse;
import pl.gsmservice.gateway.models.operations.GetMessagesRequest;
import pl.gsmservice.gateway.models.operations.GetMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.GetMessagesResponse;
import pl.gsmservice.gateway.models.operations.ListMessagesRequest;
import pl.gsmservice.gateway.models.operations.ListMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.ListMessagesResponse;
import pl.gsmservice.gateway.operations.CancelMessages;
import pl.gsmservice.gateway.operations.GetMessages;
import pl.gsmservice.gateway.operations.ListMessages;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;


public class Outgoing {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncOutgoing asyncSDK;
    private final Mms mms;
    private final Sms sms;

    Outgoing(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.mms = new Mms(this.sdkConfiguration);
        this.sms = new Sms(this.sdkConfiguration);
        this.asyncSDK = new AsyncOutgoing(this, sdkConfiguration);
    }

    public final Mms mms() {
        return mms;
    }

    public final Sms sms() {
        return sms;
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncOutgoing async() {
        return asyncSDK;
    }

    /**
     * Get the messages details and status by IDs
     * 
     * <p>
 * <br>
 * <br>Check the current status and details of one or more messages using their <code>ids</code>. You should pass the <code>ListOf()</code> containing unique message <em>IDs</em> (<code>Long</code> type) which details you want to fetch. Please use builder style:
 * <br>
     * <pre><code>
     * GetMessagesResponse res = sdk.outgoing().getByIds()
     *    .ids(List.of(43456L))
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 50 identifiers in one call.
 * <br>
 * <br>As a successful result a <code>GetMessagesResponse</code> object will be returned containing <code>messages</code> property of type <code>List&lt;Message&gt;</code> with <code>Message</code> objects, each object per single found message. <code>GetMessagesResponse</code> object will also contain <code>headers</code> property where you can find <code>X-Success-Count</code> (a count of messages which were found and returned correctly) and <code>X-Error-Count</code> (count of messages which were not found) elements.
     * 
     * @return The call builder
     */
    public GetMessagesRequestBuilder getByIds() {
        return new GetMessagesRequestBuilder(sdkConfiguration);
    }

    /**
     * Get the messages details and status by IDs
     * 
     * <p>
 * <br>
 * <br>Check the current status and details of one or more messages using their <code>ids</code>. You should pass the <code>ListOf()</code> containing unique message <em>IDs</em> (<code>Long</code> type) which details you want to fetch. Please use builder style:
 * <br>
     * <pre><code>
     * GetMessagesResponse res = sdk.outgoing().getByIds()
     *    .ids(List.of(43456L))
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 50 identifiers in one call.
 * <br>
 * <br>As a successful result a <code>GetMessagesResponse</code> object will be returned containing <code>messages</code> property of type <code>List&lt;Message&gt;</code> with <code>Message</code> objects, each object per single found message. <code>GetMessagesResponse</code> object will also contain <code>headers</code> property where you can find <code>X-Success-Count</code> (a count of messages which were found and returned correctly) and <code>X-Error-Count</code> (count of messages which were not found) elements.
     * 
     * @param ids List<Long> of Message IDs assigned by the system. The system will accept a maximum of 50 identifiers in one call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetMessagesResponse getByIds(List<Long> ids) throws Exception {
        return getByIds(ids, Optional.empty());
    }

    /**
     * Get the messages details and status by IDs
     * 
     * <p>
 * <br>
 * <br>Check the current status and details of one or more messages using their <code>ids</code>. You should pass the <code>ListOf()</code> containing unique message <em>IDs</em> (<code>Long</code> type) which details you want to fetch. Please use builder style:
 * <br>
     * <pre><code>
     * GetMessagesResponse res = sdk.outgoing().getByIds()
     *    .ids(List.of(43456L))
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 50 identifiers in one call.
 * <br>
 * <br>As a successful result a <code>GetMessagesResponse</code> object will be returned containing <code>messages</code> property of type <code>List&lt;Message&gt;</code> with <code>Message</code> objects, each object per single found message. <code>GetMessagesResponse</code> object will also contain <code>headers</code> property where you can find <code>X-Success-Count</code> (a count of messages which were found and returned correctly) and <code>X-Error-Count</code> (count of messages which were not found) elements.
     * 
     * @param ids List<Long> of Message IDs assigned by the system. The system will accept a maximum of 50 identifiers in one call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetMessagesResponse getByIds(List<Long> ids, Optional<Options> options) throws Exception {
        GetMessagesRequest request =
            GetMessagesRequest
                .builder()
                .ids(ids)
                .build();
        RequestOperation<GetMessagesRequest, GetMessagesResponse> operation
              = new GetMessages.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Cancel a scheduled messages
     * 
     * <p>
 * <br>
 * <br>Cancel messages using their <code>ids</code> which were scheduled to be sent at a specific time. You have to pass a <code>ListOf()</code> containing the unique message IDs (<code>Long</code> type), which were returned after sending a message. Please use builder style:
 * <br>
     * <pre><code>
     * CancelMessagesResponse res2 = sdk.outgoing().cancelScheduled()
     *    .ids(List.of(43456L))
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 50 identifiers in one call. You can cancel only messages with <em>SCHEDULED</em> status.
     * 
     * <p>As a successful result a <code>CancelMessagesResponse</code> object will be returned, with <code>cancelledMessages</code> property of type <code>List&lt;CancelledMessage&gt;</code> containing <code>CancelledMessage</code> objects. The <code>status</code> property of each <code>CancelledMessage</code> object will contain a status code of operation - <code>204</code> if a particular message was cancelled successfully and other code if an error occured.
     * 
     * <p><code>CancelMessagesResponse</code> object will also contain <code>headers</code> property where you can find <code>X-Success-Count</code> (a count of messages which were cancelled successfully), <code>X-Error-Count</code> (count of messages which were not cancelled) and <code>X-Sandbox</code> (if a request was made in Sandbox or Production system) elements.
     * 
     * @return The call builder
     */
    public CancelMessagesRequestBuilder cancelScheduled() {
        return new CancelMessagesRequestBuilder(sdkConfiguration);
    }

    /**
     * Cancel a scheduled messages
     * 
     * <p>
 * <br>
 * <br>Cancel messages using their <code>ids</code> which were scheduled to be sent at a specific time. You have to pass a <code>ListOf()</code> containing the unique message IDs (<code>Long</code> type), which were returned after sending a message. Please use builder style:
 * <br>
     * <pre><code>
     * CancelMessagesResponse res2 = sdk.outgoing().cancelScheduled()
     *    .ids(List.of(43456L))
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 50 identifiers in one call. You can cancel only messages with <em>SCHEDULED</em> status.
     * 
     * <p>As a successful result a <code>CancelMessagesResponse</code> object will be returned, with <code>cancelledMessages</code> property of type <code>List&lt;CancelledMessage&gt;</code> containing <code>CancelledMessage</code> objects. The <code>status</code> property of each <code>CancelledMessage</code> object will contain a status code of operation - <code>204</code> if a particular message was cancelled successfully and other code if an error occured.
     * 
     * <p><code>CancelMessagesResponse</code> object will also contain <code>headers</code> property where you can find <code>X-Success-Count</code> (a count of messages which were cancelled successfully), <code>X-Error-Count</code> (count of messages which were not cancelled) and <code>X-Sandbox</code> (if a request was made in Sandbox or Production system) elements.
     * 
     * @param ids List<Long> of Message IDs assigned by the system. The system will accept a maximum of 50 identifiers in one call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CancelMessagesResponse cancelScheduled(List<Long> ids) throws Exception {
        return cancelScheduled(ids, Optional.empty());
    }

    /**
     * Cancel a scheduled messages
     * 
     * <p>
 * <br>
 * <br>Cancel messages using their <code>ids</code> which were scheduled to be sent at a specific time. You have to pass a <code>ListOf()</code> containing the unique message IDs (<code>Long</code> type), which were returned after sending a message. Please use builder style:
 * <br>
     * <pre><code>
     * CancelMessagesResponse res2 = sdk.outgoing().cancelScheduled()
     *    .ids(List.of(43456L))
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 50 identifiers in one call. You can cancel only messages with <em>SCHEDULED</em> status.
     * 
     * <p>As a successful result a <code>CancelMessagesResponse</code> object will be returned, with <code>cancelledMessages</code> property of type <code>List&lt;CancelledMessage&gt;</code> containing <code>CancelledMessage</code> objects. The <code>status</code> property of each <code>CancelledMessage</code> object will contain a status code of operation - <code>204</code> if a particular message was cancelled successfully and other code if an error occured.
     * 
     * <p><code>CancelMessagesResponse</code> object will also contain <code>headers</code> property where you can find <code>X-Success-Count</code> (a count of messages which were cancelled successfully), <code>X-Error-Count</code> (count of messages which were not cancelled) and <code>X-Sandbox</code> (if a request was made in Sandbox or Production system) elements.
     * 
     * @param ids List<Long> of Message IDs assigned by the system. The system will accept a maximum of 50 identifiers in one call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CancelMessagesResponse cancelScheduled(List<Long> ids, Optional<Options> options) throws Exception {
        CancelMessagesRequest request =
            CancelMessagesRequest
                .builder()
                .ids(ids)
                .build();
        RequestOperation<CancelMessagesRequest, CancelMessagesResponse> operation
              = new CancelMessages.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Lists the history of sent messages
     * 
     * <p>
 * <br>
 * <br>Get the details and current status of all of sent messages from your account message history. This method supports pagination so you have to pass a <code>page</code> (number of page with messages which you want to access, <code>Long</code> type) and a <code>limit</code> (max of messages per page, <code>Long</code> type) parameters. Please use builder style:
 * <br>
     * <pre><code>
     * ListMessagesResponse res = sdk.outgoing().list()
     *    .page(1L)
     *    .limit(10L)
     *    .call();
     * </code></pre>
     * 
 * <br>Messages are fetched from the latest one. This method will accept maximum value of <strong>50</strong> as <code>limit</code> parameter value.
 * <br>
 * <br>As a successful result a <code>ListMessagesResponse</code> object will be returned containing <code>messages</code> property of type <code>List&lt;Message&gt;</code> with a <code>Message</code> objects, each object per single message. <code>ListMessagesResponse</code> will also contain <code>headers</code> property where you can find <code>X-Total-Results</code> (a total count of all messages which are available in history on your account), <code>X-Total-Pages</code> (a total number of all pages with results), <code>X-Current-Page</code> (A current page number) and <code>X-Limit</code> (messages count per single page) elements.
     * 
     * @return The call builder
     */
    public ListMessagesRequestBuilder list() {
        return new ListMessagesRequestBuilder(sdkConfiguration);
    }

    /**
     * Lists the history of sent messages
     * 
     * <p>
 * <br>
 * <br>Get the details and current status of all of sent messages from your account message history. This method supports pagination so you have to pass a <code>page</code> (number of page with messages which you want to access, <code>Long</code> type) and a <code>limit</code> (max of messages per page, <code>Long</code> type) parameters. Please use builder style:
 * <br>
     * <pre><code>
     * ListMessagesResponse res = sdk.outgoing().list()
     *    .page(1L)
     *    .limit(10L)
     *    .call();
     * </code></pre>
     * 
 * <br>Messages are fetched from the latest one. This method will accept maximum value of <strong>50</strong> as <code>limit</code> parameter value.
 * <br>
 * <br>As a successful result a <code>ListMessagesResponse</code> object will be returned containing <code>messages</code> property of type <code>List&lt;Message&gt;</code> with a <code>Message</code> objects, each object per single message. <code>ListMessagesResponse</code> will also contain <code>headers</code> property where you can find <code>X-Total-Results</code> (a total count of all messages which are available in history on your account), <code>X-Total-Pages</code> (a total number of all pages with results), <code>X-Current-Page</code> (A current page number) and <code>X-Limit</code> (messages count per single page) elements.
     * 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListMessagesResponse listDirect() throws Exception {
        return list(Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * Lists the history of sent messages
     * 
     * <p>
 * <br>
 * <br>Get the details and current status of all of sent messages from your account message history. This method supports pagination so you have to pass a <code>page</code> (number of page with messages which you want to access, <code>Long</code> type) and a <code>limit</code> (max of messages per page, <code>Long</code> type) parameters. Please use builder style:
 * <br>
     * <pre><code>
     * ListMessagesResponse res = sdk.outgoing().list()
     *    .page(1L)
     *    .limit(10L)
     *    .call();
     * </code></pre>
     * 
 * <br>Messages are fetched from the latest one. This method will accept maximum value of <strong>50</strong> as <code>limit</code> parameter value.
 * <br>
 * <br>As a successful result a <code>ListMessagesResponse</code> object will be returned containing <code>messages</code> property of type <code>List&lt;Message&gt;</code> with a <code>Message</code> objects, each object per single message. <code>ListMessagesResponse</code> will also contain <code>headers</code> property where you can find <code>X-Total-Results</code> (a total count of all messages which are available in history on your account), <code>X-Total-Pages</code> (a total number of all pages with results), <code>X-Current-Page</code> (A current page number) and <code>X-Limit</code> (messages count per single page) elements.
     * 
     * @param page Page number of results
     * @param limit Number of results on one page
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListMessagesResponse list(
            Optional<Long> page, Optional<Long> limit,
            Optional<Options> options) throws Exception {
        ListMessagesRequest request =
            ListMessagesRequest
                .builder()
                .page(page)
                .limit(limit)
                .build();
        RequestOperation<ListMessagesRequest, ListMessagesResponse> operation
              = new ListMessages.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

}
