/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway;

import java.lang.String;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import pl.gsmservice.gateway.utils.AsyncHooks;
import pl.gsmservice.gateway.utils.HTTPClient;
import pl.gsmservice.gateway.utils.Hooks;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.SpeakeasyHTTPClient;
import pl.gsmservice.gateway.utils.Utils;

public class SDKConfiguration {

    private static final String LANGUAGE = "java";
    public static final String OPENAPI_DOC_VERSION = "1.2.2";
    public static final String SDK_VERSION = "4.0.1";
    public static final String GEN_VERSION = "2.716.5";
    private static final String BASE_PACKAGE = "pl.gsmservice.gateway";
    public static final String USER_AGENT = 
            String.format("speakeasy-sdk/%s %s %s %s %s",
                LANGUAGE, SDK_VERSION, GEN_VERSION, OPENAPI_DOC_VERSION, BASE_PACKAGE);

    private SecuritySource securitySource = SecuritySource.of(null);
    
    public SecuritySource securitySource() {
        return securitySource;
    }
    
    public void setSecuritySource(SecuritySource securitySource) {
        Utils.checkNotNull(securitySource, "securitySource");
        this.securitySource = securitySource;
    }
    
    private HTTPClient client = new SpeakeasyHTTPClient();
    
    public HTTPClient client() {
        return client;
    }
    
    public void setClient(HTTPClient client) {
        Utils.checkNotNull(client, "client");
        this.client = client;
    }
    
    private String serverUrl;
    
    public String serverUrl() {
        return serverUrl;
    }
    
    public void setServerUrl(String serverUrl) {
        Utils.checkNotNull(serverUrl, "serverUrl");
        this.serverUrl = trimFinalSlash(serverUrl);
    }
    
    private static String trimFinalSlash(String url) {
        if (url == null) {
            return null;
        } else if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        } else  {
            return url;
        }
    }
    
    public String resolvedServerUrl() {
        return serverUrl;
    }
    
    // the name of the server to use from the server map
    private String server;
    
    public void setServer(String server) {
        Utils.checkNotNull(server, "server");
        this.server = server;
    }
    
    public String server() {
        return server;
    }
    
    
    private Hooks _hooks = createHooks();

    private static Hooks createHooks() {
        Hooks hooks = new Hooks();
        return hooks;
    }
    
    public Hooks hooks() {
        return _hooks;
    }

    public void setHooks(Hooks hooks) {
        this._hooks = hooks;
    }

    /**
     * Initializes state (for example hooks).
     **/
    public void initialize() {
    }

    
    
    private Optional<RetryConfig> retryConfig = Optional.empty();
    
    public Optional<RetryConfig> retryConfig() {
        return retryConfig;
    }

    public void setRetryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
    }
    private ScheduledExecutorService retryScheduler = Executors.newSingleThreadScheduledExecutor();
    
    public ScheduledExecutorService retryScheduler() {
        return retryScheduler;
    }

    public void setAsyncRetryScheduler(ScheduledExecutorService retryScheduler) {
        Utils.checkNotNull(retryScheduler, "retryScheduler");
        this.retryScheduler = retryScheduler;
    }

    private AsyncHooks _asyncHooks = new AsyncHooks();

    public AsyncHooks asyncHooks() {
        return _asyncHooks;
    }

    public void setAsyncHooks(AsyncHooks asyncHooks) {
        Utils.checkNotNull(asyncHooks, "asyncHooks");
        this._asyncHooks = asyncHooks;
    }
}
