/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway;

import static pl.gsmservice.gateway.operations.Operations.RequestlessOperation;
import static pl.gsmservice.gateway.operations.Operations.RequestOperation;

import java.lang.Exception;
import java.lang.String;
import java.util.Optional;
import pl.gsmservice.gateway.models.components.SenderInput;
import pl.gsmservice.gateway.models.operations.AddSenderRequestBuilder;
import pl.gsmservice.gateway.models.operations.AddSenderResponse;
import pl.gsmservice.gateway.models.operations.DeleteSenderRequest;
import pl.gsmservice.gateway.models.operations.DeleteSenderRequestBuilder;
import pl.gsmservice.gateway.models.operations.DeleteSenderResponse;
import pl.gsmservice.gateway.models.operations.ListSendersRequestBuilder;
import pl.gsmservice.gateway.models.operations.ListSendersResponse;
import pl.gsmservice.gateway.models.operations.SetDefaultSenderRequest;
import pl.gsmservice.gateway.models.operations.SetDefaultSenderRequestBuilder;
import pl.gsmservice.gateway.models.operations.SetDefaultSenderResponse;
import pl.gsmservice.gateway.operations.AddSender;
import pl.gsmservice.gateway.operations.DeleteSender;
import pl.gsmservice.gateway.operations.ListSenders;
import pl.gsmservice.gateway.operations.SetDefaultSender;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;


public class Senders {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncSenders asyncSDK;

    Senders(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncSenders(this, sdkConfiguration);
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncSenders async() {
        return asyncSDK;
    }

    /**
     * List allowed senders names
     * 
     * <p>
 * <br>
 * <br>Get a list of allowed senders defined in your account. The method doesn't take any parameters. Please use builder style:
 * <br>
     * <pre><code>
     * ListSendersResponse res = sdk.senders().list()
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result a <code>ListSendersResponse</code> object will be returned wich <code>senders</code> property of type <code>List&lt;Sender&gt;</code> containing <code>Sender</code> objects, each object per single sender.
     * 
     * @return The call builder
     */
    public ListSendersRequestBuilder list() {
        return new ListSendersRequestBuilder(sdkConfiguration);
    }

    /**
     * List allowed senders names
     * 
     * <p>
 * <br>
 * <br>Get a list of allowed senders defined in your account. The method doesn't take any parameters. Please use builder style:
 * <br>
     * <pre><code>
     * ListSendersResponse res = sdk.senders().list()
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result a <code>ListSendersResponse</code> object will be returned wich <code>senders</code> property of type <code>List&lt;Sender&gt;</code> containing <code>Sender</code> objects, each object per single sender.
     * 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListSendersResponse listDirect() throws Exception {
        return list(Optional.empty());
    }

    /**
     * List allowed senders names
     * 
     * <p>
 * <br>
 * <br>Get a list of allowed senders defined in your account. The method doesn't take any parameters. Please use builder style:
 * <br>
     * <pre><code>
     * ListSendersResponse res = sdk.senders().list()
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful result a <code>ListSendersResponse</code> object will be returned wich <code>senders</code> property of type <code>List&lt;Sender&gt;</code> containing <code>Sender</code> objects, each object per single sender.
     * 
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListSendersResponse list(Optional<Options> options) throws Exception {
        RequestlessOperation<ListSendersResponse> operation
            = new ListSenders.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest());
    }

    /**
     * Add a new sender name
     * 
     * <p>
 * <br>
 * <br>Define a new allowed sender on your account. You should pass as parameter a <code>SenderInput</code> object with two properties: <code>sender</code> (defines sender name) and <code>description</code>. Please use builder style:
 * <br>
     * <pre><code>
     * AddSenderResponse res = sdk.senders().add()
     *    .request(req)
     *    .call();
     * </code></pre>
     * 
 * <br>Please carefully fill this property with the extensive description of a sender name (what will be its use, what the name mean, etc). 
 * <br>
 * <br>As a successful result a <code>AddSenderResponse</code> object will be returned with a <code>sender</code> property containing a <code>Sender</code> object with details and status of added sender name.
     * 
     * @return The call builder
     */
    public AddSenderRequestBuilder add() {
        return new AddSenderRequestBuilder(sdkConfiguration);
    }

    /**
     * Add a new sender name
     * 
     * <p>
 * <br>
 * <br>Define a new allowed sender on your account. You should pass as parameter a <code>SenderInput</code> object with two properties: <code>sender</code> (defines sender name) and <code>description</code>. Please use builder style:
 * <br>
     * <pre><code>
     * AddSenderResponse res = sdk.senders().add()
     *    .request(req)
     *    .call();
     * </code></pre>
     * 
 * <br>Please carefully fill this property with the extensive description of a sender name (what will be its use, what the name mean, etc). 
 * <br>
 * <br>As a successful result a <code>AddSenderResponse</code> object will be returned with a <code>sender</code> property containing a <code>Sender</code> object with details and status of added sender name.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public AddSenderResponse add(SenderInput request) throws Exception {
        return add(request, Optional.empty());
    }

    /**
     * Add a new sender name
     * 
     * <p>
 * <br>
 * <br>Define a new allowed sender on your account. You should pass as parameter a <code>SenderInput</code> object with two properties: <code>sender</code> (defines sender name) and <code>description</code>. Please use builder style:
 * <br>
     * <pre><code>
     * AddSenderResponse res = sdk.senders().add()
     *    .request(req)
     *    .call();
     * </code></pre>
     * 
 * <br>Please carefully fill this property with the extensive description of a sender name (what will be its use, what the name mean, etc). 
 * <br>
 * <br>As a successful result a <code>AddSenderResponse</code> object will be returned with a <code>sender</code> property containing a <code>Sender</code> object with details and status of added sender name.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public AddSenderResponse add(SenderInput request, Optional<Options> options) throws Exception {
        RequestOperation<SenderInput, AddSenderResponse> operation
              = new AddSender.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Delete a sender name
     * 
     * <p>
 * <br>
 * <br>Removes defined sender name from your account. This method accepts a <code>string</code> with a <strong>sender name</strong> you want to remove. Please use builder style:
 * <br>
     * <pre><code>
     * DeleteSenderResponse res = sdk.senders().delete()
     *    .sender("Podpis")
     *    .call();
     * </code></pre>
     * 
 * <br>Sender name will be deleted immediately.
 * <br>
 * <br>As a successful response a <code>DeleteSenderResponse</code> object will de returned with <code>statusCode</code> property of <code>204</code>.
     * 
     * @return The call builder
     */
    public DeleteSenderRequestBuilder delete() {
        return new DeleteSenderRequestBuilder(sdkConfiguration);
    }

    /**
     * Delete a sender name
     * 
     * <p>
 * <br>
 * <br>Removes defined sender name from your account. This method accepts a <code>string</code> with a <strong>sender name</strong> you want to remove. Please use builder style:
 * <br>
     * <pre><code>
     * DeleteSenderResponse res = sdk.senders().delete()
     *    .sender("Podpis")
     *    .call();
     * </code></pre>
     * 
 * <br>Sender name will be deleted immediately.
 * <br>
 * <br>As a successful response a <code>DeleteSenderResponse</code> object will de returned with <code>statusCode</code> property of <code>204</code>.
     * 
     * @param sender Sender name to be removed
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public DeleteSenderResponse delete(String sender) throws Exception {
        return delete(sender, Optional.empty());
    }

    /**
     * Delete a sender name
     * 
     * <p>
 * <br>
 * <br>Removes defined sender name from your account. This method accepts a <code>string</code> with a <strong>sender name</strong> you want to remove. Please use builder style:
 * <br>
     * <pre><code>
     * DeleteSenderResponse res = sdk.senders().delete()
     *    .sender("Podpis")
     *    .call();
     * </code></pre>
     * 
 * <br>Sender name will be deleted immediately.
 * <br>
 * <br>As a successful response a <code>DeleteSenderResponse</code> object will de returned with <code>statusCode</code> property of <code>204</code>.
     * 
     * @param sender Sender name to be removed
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public DeleteSenderResponse delete(String sender, Optional<Options> options) throws Exception {
        DeleteSenderRequest request =
            DeleteSenderRequest
                .builder()
                .sender(sender)
                .build();
        RequestOperation<DeleteSenderRequest, DeleteSenderResponse> operation
              = new DeleteSender.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Set default sender name
     * 
     * <p>
 * <br>
 * <br>Set default sender name to one of the senders names already defined on your account. This method accepts a <code>string</code> containing a <strong>sender name</strong> to be set as default on your account. Please use a builder style:
 * <br>
     * <pre><code>
     * SetDefaultSenderResponse res = sdk.senders().setDefault()
     *    .sender("Podpis")
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful response a <code>SetDefaultSenderResponse</code> will be returned with <code>statusCode</code> property of <code>204</code>.
     * 
     * @return The call builder
     */
    public SetDefaultSenderRequestBuilder setDefault() {
        return new SetDefaultSenderRequestBuilder(sdkConfiguration);
    }

    /**
     * Set default sender name
     * 
     * <p>
 * <br>
 * <br>Set default sender name to one of the senders names already defined on your account. This method accepts a <code>string</code> containing a <strong>sender name</strong> to be set as default on your account. Please use a builder style:
 * <br>
     * <pre><code>
     * SetDefaultSenderResponse res = sdk.senders().setDefault()
     *    .sender("Podpis")
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful response a <code>SetDefaultSenderResponse</code> will be returned with <code>statusCode</code> property of <code>204</code>.
     * 
     * @param sender Sender name to set as default
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public SetDefaultSenderResponse setDefault(String sender) throws Exception {
        return setDefault(sender, Optional.empty());
    }

    /**
     * Set default sender name
     * 
     * <p>
 * <br>
 * <br>Set default sender name to one of the senders names already defined on your account. This method accepts a <code>string</code> containing a <strong>sender name</strong> to be set as default on your account. Please use a builder style:
 * <br>
     * <pre><code>
     * SetDefaultSenderResponse res = sdk.senders().setDefault()
     *    .sender("Podpis")
     *    .call();
     * </code></pre>
     * 
 * <br>As a successful response a <code>SetDefaultSenderResponse</code> will be returned with <code>statusCode</code> property of <code>204</code>.
     * 
     * @param sender Sender name to set as default
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public SetDefaultSenderResponse setDefault(String sender, Optional<Options> options) throws Exception {
        SetDefaultSenderRequest request =
            SetDefaultSenderRequest
                .builder()
                .sender(sender)
                .build();
        RequestOperation<SetDefaultSenderRequest, SetDefaultSenderResponse> operation
              = new SetDefaultSender.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

}
