/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway;

import static pl.gsmservice.gateway.operations.Operations.RequestOperation;

import java.lang.Exception;
import java.util.Optional;
import pl.gsmservice.gateway.models.operations.GetSmsPriceRequestBody;
import pl.gsmservice.gateway.models.operations.GetSmsPriceRequestBuilder;
import pl.gsmservice.gateway.models.operations.GetSmsPriceResponse;
import pl.gsmservice.gateway.models.operations.SendSmsRequestBody;
import pl.gsmservice.gateway.models.operations.SendSmsRequestBuilder;
import pl.gsmservice.gateway.models.operations.SendSmsResponse;
import pl.gsmservice.gateway.operations.GetSmsPrice;
import pl.gsmservice.gateway.operations.SendSms;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;


public class Sms {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncSms asyncSDK;

    Sms(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncSms(this, sdkConfiguration);
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncSms async() {
        return asyncSDK;
    }

    /**
     * Check the price of SMS Messages
     * 
     * <p>
 * <br>
 * <br>Check the price of single or multiple SMS messages at the same time before sending them. You can pass a single <code>SmsMessage</code> object using <code>GetSmsPriceRequestBody.of(SmsMessage)</code> method (for single message) or <code>List&lt;SmsMessage&gt;</code> using <code>GetSmsPriceRequestBody.of(List.of(SmsMessage,...))</code> method (for multiple messages).
 * <br>
 * <br>Each <code>SmsMessage</code> object has several properties, describing message parameters such as recipient phone number, content of the message, type, etc. Please use builder style:
 * <br>
     * <pre><code>
     * GetSmsPriceResponse res = sdk.outgoing().sms().getPrice()
     *    .request(req) // here pass GetSmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>The method will accept maximum <strong>100</strong> messages in one call.
 * <br>
 * <br>As a successful result a <code>GetSmsPriceResponse</code> object will be returned with <code>prices</code> property of type <code>List&lt;Price&gt;</code> containing a <code>Price</code> objects, one object per each single message. You should check the <code>error</code> property of each <code>Price</code> object to make sure which messages were priced successfully and which finished with an error. Successfully priced messages will have <code>null</code> value of <code>error</code> property.
 * <br>
 * <br><code>GetSmsPriceResponse</code> object will include also <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully) and <code>X-Error-Count</code> (count of messages which were rejected) elements.
     * 
     * @return The call builder
     */
    public GetSmsPriceRequestBuilder getPrice() {
        return new GetSmsPriceRequestBuilder(sdkConfiguration);
    }

    /**
     * Check the price of SMS Messages
     * 
     * <p>
 * <br>
 * <br>Check the price of single or multiple SMS messages at the same time before sending them. You can pass a single <code>SmsMessage</code> object using <code>GetSmsPriceRequestBody.of(SmsMessage)</code> method (for single message) or <code>List&lt;SmsMessage&gt;</code> using <code>GetSmsPriceRequestBody.of(List.of(SmsMessage,...))</code> method (for multiple messages).
 * <br>
 * <br>Each <code>SmsMessage</code> object has several properties, describing message parameters such as recipient phone number, content of the message, type, etc. Please use builder style:
 * <br>
     * <pre><code>
     * GetSmsPriceResponse res = sdk.outgoing().sms().getPrice()
     *    .request(req) // here pass GetSmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>The method will accept maximum <strong>100</strong> messages in one call.
 * <br>
 * <br>As a successful result a <code>GetSmsPriceResponse</code> object will be returned with <code>prices</code> property of type <code>List&lt;Price&gt;</code> containing a <code>Price</code> objects, one object per each single message. You should check the <code>error</code> property of each <code>Price</code> object to make sure which messages were priced successfully and which finished with an error. Successfully priced messages will have <code>null</code> value of <code>error</code> property.
 * <br>
 * <br><code>GetSmsPriceResponse</code> object will include also <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully) and <code>X-Error-Count</code> (count of messages which were rejected) elements.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetSmsPriceResponse getPrice(GetSmsPriceRequestBody request) throws Exception {
        return getPrice(request, Optional.empty());
    }

    /**
     * Check the price of SMS Messages
     * 
     * <p>
 * <br>
 * <br>Check the price of single or multiple SMS messages at the same time before sending them. You can pass a single <code>SmsMessage</code> object using <code>GetSmsPriceRequestBody.of(SmsMessage)</code> method (for single message) or <code>List&lt;SmsMessage&gt;</code> using <code>GetSmsPriceRequestBody.of(List.of(SmsMessage,...))</code> method (for multiple messages).
 * <br>
 * <br>Each <code>SmsMessage</code> object has several properties, describing message parameters such as recipient phone number, content of the message, type, etc. Please use builder style:
 * <br>
     * <pre><code>
     * GetSmsPriceResponse res = sdk.outgoing().sms().getPrice()
     *    .request(req) // here pass GetSmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>The method will accept maximum <strong>100</strong> messages in one call.
 * <br>
 * <br>As a successful result a <code>GetSmsPriceResponse</code> object will be returned with <code>prices</code> property of type <code>List&lt;Price&gt;</code> containing a <code>Price</code> objects, one object per each single message. You should check the <code>error</code> property of each <code>Price</code> object to make sure which messages were priced successfully and which finished with an error. Successfully priced messages will have <code>null</code> value of <code>error</code> property.
 * <br>
 * <br><code>GetSmsPriceResponse</code> object will include also <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully) and <code>X-Error-Count</code> (count of messages which were rejected) elements.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetSmsPriceResponse getPrice(GetSmsPriceRequestBody request, Optional<Options> options) throws Exception {
        RequestOperation<GetSmsPriceRequestBody, GetSmsPriceResponse> operation
              = new GetSmsPrice.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Send SMS Messages
     * 
     * <p>
 * <br>
 * <br>Send single or multiple SMS messages at the same time. You can pass a single <code>SmsMessage</code> object using <code>SendSmsRequestBody.of(SmsMessage)</code> method (for single message) or <code>List&lt;SmsMessage&gt;</code> using <code>SendSmsRequestBody.of(List.of(SmsMessage,...))</code> method (for multiple messages). Each <code>SmsMessage</code> object has several properties, describing message parameters such recipient phone number, content of the message, type or scheduled sending date, etc. Please use builder style:
 * <br>
     * <pre><code>
     * SendSmsResponse res = sdk.outgoing().sms().send()
     *    .request(req) // here pass GetSmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 100 messages in one call.
 * <br>
 * <br>As a successful result a <code>SendSmsResponse</code> object will be returned with <code>messages</code> property of type List&lt;Message&gt; containing <code>Message</code> objects, one object per each single message. You should check the <code>statusCode</code> property of each <code>Message</code> object to make sure which messages were accepted by gateway (queued) and which were rejected. In case of rejection, <code>statusDescription</code> property will include a reason.
 * <br>
 * <br><code>SendSmsResponse</code> will also include <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully), <code>X-Error-Count</code> (count of messages which were rejected) and <code>X-Sandbox</code> (if a request was made in Sandbox or Production system) elements.
     * 
     * @return The call builder
     */
    public SendSmsRequestBuilder send() {
        return new SendSmsRequestBuilder(sdkConfiguration);
    }

    /**
     * Send SMS Messages
     * 
     * <p>
 * <br>
 * <br>Send single or multiple SMS messages at the same time. You can pass a single <code>SmsMessage</code> object using <code>SendSmsRequestBody.of(SmsMessage)</code> method (for single message) or <code>List&lt;SmsMessage&gt;</code> using <code>SendSmsRequestBody.of(List.of(SmsMessage,...))</code> method (for multiple messages). Each <code>SmsMessage</code> object has several properties, describing message parameters such recipient phone number, content of the message, type or scheduled sending date, etc. Please use builder style:
 * <br>
     * <pre><code>
     * SendSmsResponse res = sdk.outgoing().sms().send()
     *    .request(req) // here pass GetSmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 100 messages in one call.
 * <br>
 * <br>As a successful result a <code>SendSmsResponse</code> object will be returned with <code>messages</code> property of type List&lt;Message&gt; containing <code>Message</code> objects, one object per each single message. You should check the <code>statusCode</code> property of each <code>Message</code> object to make sure which messages were accepted by gateway (queued) and which were rejected. In case of rejection, <code>statusDescription</code> property will include a reason.
 * <br>
 * <br><code>SendSmsResponse</code> will also include <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully), <code>X-Error-Count</code> (count of messages which were rejected) and <code>X-Sandbox</code> (if a request was made in Sandbox or Production system) elements.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public SendSmsResponse send(SendSmsRequestBody request) throws Exception {
        return send(request, Optional.empty());
    }

    /**
     * Send SMS Messages
     * 
     * <p>
 * <br>
 * <br>Send single or multiple SMS messages at the same time. You can pass a single <code>SmsMessage</code> object using <code>SendSmsRequestBody.of(SmsMessage)</code> method (for single message) or <code>List&lt;SmsMessage&gt;</code> using <code>SendSmsRequestBody.of(List.of(SmsMessage,...))</code> method (for multiple messages). Each <code>SmsMessage</code> object has several properties, describing message parameters such recipient phone number, content of the message, type or scheduled sending date, etc. Please use builder style:
 * <br>
     * <pre><code>
     * SendSmsResponse res = sdk.outgoing().sms().send()
     *    .request(req) // here pass GetSmsPriceRequestBody.of(...) object
     *    .call();
     * </code></pre>
     * 
 * <br>This method will accept maximum 100 messages in one call.
 * <br>
 * <br>As a successful result a <code>SendSmsResponse</code> object will be returned with <code>messages</code> property of type List&lt;Message&gt; containing <code>Message</code> objects, one object per each single message. You should check the <code>statusCode</code> property of each <code>Message</code> object to make sure which messages were accepted by gateway (queued) and which were rejected. In case of rejection, <code>statusDescription</code> property will include a reason.
 * <br>
 * <br><code>SendSmsResponse</code> will also include <code>headers</code> property with <code>X-Success-Count</code> (a count of messages which were processed successfully), <code>X-Error-Count</code> (count of messages which were rejected) and <code>X-Sandbox</code> (if a request was made in Sandbox or Production system) elements.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public SendSmsResponse send(SendSmsRequestBody request, Optional<Options> options) throws Exception {
        RequestOperation<SendSmsRequestBody, SendSmsResponse> operation
              = new SendSms.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

}
