/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;
import pl.gsmservice.gateway.utils.LazySingletonValue;
import pl.gsmservice.gateway.utils.Utils;

/**
 * MmsMessage
 * 
 * <p>An object with a new MMS message properties
 */
public class MmsMessage {
    /**
     * The recipient number or multiple recipients numbers of single message. To set one recipient, please use <code>Recipients.of(String)</code> method simply passing to it a <code>string</code> with his phone number. To set multiple recipients, please use <code>Recipients.ofArrayOfStrings(List.of(String,...))</code> method passing to it <code>List&lt;string&gt;</code>. Optionally you can also set custom id (user identifier) for each message - use <code>Recipients.of(PhoneNumberWithCid)</code> method passing <code>PhoneNumberWithCid</code> object (in case of single recipient) or <code>Recipients.ofArrayOfPhoneNumberWithCids(Recipients.of(PhoneNumberWithCid,...))</code> method passing List&lt;PhoneNumberWithCid&gt; (in case of multiple recipients).
     */
    @JsonProperty("recipients")
    private Recipients recipients;

    /**
     * MMS message subject
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("subject")
    private JsonNullable<String> subject;

    /**
     * MMS message content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("message")
    private JsonNullable<String> message;

    /**
     * Attachments for the message. You can pass here images, audio and video files bodies. To set one attachment please use <code>Attachments.of(String)</code> method simply passing to it a <code>string</code> with attachment body encoded by <code>base64</code>. To set multiple attachments please use <code>Attachments.of(List.of(String,...))</code> method passing to it <code>List&lt;string&gt;</code> with attachments bodies encoded by <code>base64</code>. Max 3 attachments per message.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("attachments")
    private Optional<? extends Attachments> attachments;

    /**
     * Scheduled future date and time of sending the message (in ISO 8601 format). If missing or null - message will be sent immediately
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("date")
    private JsonNullable<OffsetDateTime> date;

    @JsonCreator
    public MmsMessage(
            @JsonProperty("recipients") Recipients recipients,
            @JsonProperty("subject") JsonNullable<String> subject,
            @JsonProperty("message") JsonNullable<String> message,
            @JsonProperty("attachments") Optional<? extends Attachments> attachments,
            @JsonProperty("date") JsonNullable<OffsetDateTime> date) {
        Utils.checkNotNull(recipients, "recipients");
        Utils.checkNotNull(subject, "subject");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(attachments, "attachments");
        Utils.checkNotNull(date, "date");
        this.recipients = recipients;
        this.subject = subject;
        this.message = message;
        this.attachments = attachments;
        this.date = date;
    }
    
    public MmsMessage(
            Recipients recipients) {
        this(recipients, JsonNullable.undefined(), JsonNullable.undefined(),
            Optional.empty(), JsonNullable.undefined());
    }

    /**
     * The recipient number or multiple recipients numbers of single message. To set one recipient, please use <code>Recipients.of(String)</code> method simply passing to it a <code>string</code> with his phone number. To set multiple recipients, please use <code>Recipients.ofArrayOfStrings(List.of(String,...))</code> method passing to it <code>List&lt;string&gt;</code>. Optionally you can also set custom id (user identifier) for each message - use <code>Recipients.of(PhoneNumberWithCid)</code> method passing <code>PhoneNumberWithCid</code> object (in case of single recipient) or <code>Recipients.ofArrayOfPhoneNumberWithCids(Recipients.of(PhoneNumberWithCid,...))</code> method passing List&lt;PhoneNumberWithCid&gt; (in case of multiple recipients).
     */
    @JsonIgnore
    public Recipients recipients() {
        return recipients;
    }

    /**
     * MMS message subject
     */
    @JsonIgnore
    public JsonNullable<String> subject() {
        return subject;
    }

    /**
     * MMS message content
     */
    @JsonIgnore
    public JsonNullable<String> message() {
        return message;
    }

    /**
     * Attachments for the message. You can pass here images, audio and video files bodies. To set one attachment please use <code>Attachments.of(String)</code> method simply passing to it a <code>string</code> with attachment body encoded by <code>base64</code>. To set multiple attachments please use <code>Attachments.of(List.of(String,...))</code> method passing to it <code>List&lt;string&gt;</code> with attachments bodies encoded by <code>base64</code>. Max 3 attachments per message.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Attachments> attachments() {
        return (Optional<Attachments>) attachments;
    }

    /**
     * Scheduled future date and time of sending the message (in ISO 8601 format). If missing or null - message will be sent immediately
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> date() {
        return date;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The recipient number or multiple recipients numbers of single message. To set one recipient, please use <code>Recipients.of(String)</code> method simply passing to it a <code>string</code> with his phone number. To set multiple recipients, please use <code>Recipients.ofArrayOfStrings(List.of(String,...))</code> method passing to it <code>List&lt;string&gt;</code>. Optionally you can also set custom id (user identifier) for each message - use <code>Recipients.of(PhoneNumberWithCid)</code> method passing <code>PhoneNumberWithCid</code> object (in case of single recipient) or <code>Recipients.ofArrayOfPhoneNumberWithCids(Recipients.of(PhoneNumberWithCid,...))</code> method passing List&lt;PhoneNumberWithCid&gt; (in case of multiple recipients).
     */
    public MmsMessage withRecipients(Recipients recipients) {
        Utils.checkNotNull(recipients, "recipients");
        this.recipients = recipients;
        return this;
    }

    /**
     * MMS message subject
     */
    public MmsMessage withSubject(String subject) {
        Utils.checkNotNull(subject, "subject");
        this.subject = JsonNullable.of(subject);
        return this;
    }

    /**
     * MMS message subject
     */
    public MmsMessage withSubject(JsonNullable<String> subject) {
        Utils.checkNotNull(subject, "subject");
        this.subject = subject;
        return this;
    }

    /**
     * MMS message content
     */
    public MmsMessage withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = JsonNullable.of(message);
        return this;
    }

    /**
     * MMS message content
     */
    public MmsMessage withMessage(JsonNullable<String> message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    /**
     * Attachments for the message. You can pass here images, audio and video files bodies. To set one attachment please use <code>Attachments.of(String)</code> method simply passing to it a <code>string</code> with attachment body encoded by <code>base64</code>. To set multiple attachments please use <code>Attachments.of(List.of(String,...))</code> method passing to it <code>List&lt;string&gt;</code> with attachments bodies encoded by <code>base64</code>. Max 3 attachments per message.
     */
    public MmsMessage withAttachments(Attachments attachments) {
        Utils.checkNotNull(attachments, "attachments");
        this.attachments = Optional.ofNullable(attachments);
        return this;
    }


    /**
     * Attachments for the message. You can pass here images, audio and video files bodies. To set one attachment please use <code>Attachments.of(String)</code> method simply passing to it a <code>string</code> with attachment body encoded by <code>base64</code>. To set multiple attachments please use <code>Attachments.of(List.of(String,...))</code> method passing to it <code>List&lt;string&gt;</code> with attachments bodies encoded by <code>base64</code>. Max 3 attachments per message.
     */
    public MmsMessage withAttachments(Optional<? extends Attachments> attachments) {
        Utils.checkNotNull(attachments, "attachments");
        this.attachments = attachments;
        return this;
    }

    /**
     * Scheduled future date and time of sending the message (in ISO 8601 format). If missing or null - message will be sent immediately
     */
    public MmsMessage withDate(OffsetDateTime date) {
        Utils.checkNotNull(date, "date");
        this.date = JsonNullable.of(date);
        return this;
    }

    /**
     * Scheduled future date and time of sending the message (in ISO 8601 format). If missing or null - message will be sent immediately
     */
    public MmsMessage withDate(JsonNullable<OffsetDateTime> date) {
        Utils.checkNotNull(date, "date");
        this.date = date;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MmsMessage other = (MmsMessage) o;
        return 
            Utils.enhancedDeepEquals(this.recipients, other.recipients) &&
            Utils.enhancedDeepEquals(this.subject, other.subject) &&
            Utils.enhancedDeepEquals(this.message, other.message) &&
            Utils.enhancedDeepEquals(this.attachments, other.attachments) &&
            Utils.enhancedDeepEquals(this.date, other.date);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            recipients, subject, message,
            attachments, date);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MmsMessage.class,
                "recipients", recipients,
                "subject", subject,
                "message", message,
                "attachments", attachments,
                "date", date);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Recipients recipients;

        private JsonNullable<String> subject = JsonNullable.undefined();

        private JsonNullable<String> message = JsonNullable.undefined();

        private Optional<? extends Attachments> attachments = Optional.empty();

        private JsonNullable<OffsetDateTime> date;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The recipient number or multiple recipients numbers of single message. To set one recipient, please use <code>Recipients.of(String)</code> method simply passing to it a <code>string</code> with his phone number. To set multiple recipients, please use <code>Recipients.ofArrayOfStrings(List.of(String,...))</code> method passing to it <code>List&lt;string&gt;</code>. Optionally you can also set custom id (user identifier) for each message - use <code>Recipients.of(PhoneNumberWithCid)</code> method passing <code>PhoneNumberWithCid</code> object (in case of single recipient) or <code>Recipients.ofArrayOfPhoneNumberWithCids(Recipients.of(PhoneNumberWithCid,...))</code> method passing List&lt;PhoneNumberWithCid&gt; (in case of multiple recipients).
         */
        public Builder recipients(Recipients recipients) {
            Utils.checkNotNull(recipients, "recipients");
            this.recipients = recipients;
            return this;
        }


        /**
         * MMS message subject
         */
        public Builder subject(String subject) {
            Utils.checkNotNull(subject, "subject");
            this.subject = JsonNullable.of(subject);
            return this;
        }

        /**
         * MMS message subject
         */
        public Builder subject(JsonNullable<String> subject) {
            Utils.checkNotNull(subject, "subject");
            this.subject = subject;
            return this;
        }


        /**
         * MMS message content
         */
        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = JsonNullable.of(message);
            return this;
        }

        /**
         * MMS message content
         */
        public Builder message(JsonNullable<String> message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }


        /**
         * Attachments for the message. You can pass here images, audio and video files bodies. To set one attachment please use <code>Attachments.of(String)</code> method simply passing to it a <code>string</code> with attachment body encoded by <code>base64</code>. To set multiple attachments please use <code>Attachments.of(List.of(String,...))</code> method passing to it <code>List&lt;string&gt;</code> with attachments bodies encoded by <code>base64</code>. Max 3 attachments per message.
         */
        public Builder attachments(Attachments attachments) {
            Utils.checkNotNull(attachments, "attachments");
            this.attachments = Optional.ofNullable(attachments);
            return this;
        }

        /**
         * Attachments for the message. You can pass here images, audio and video files bodies. To set one attachment please use <code>Attachments.of(String)</code> method simply passing to it a <code>string</code> with attachment body encoded by <code>base64</code>. To set multiple attachments please use <code>Attachments.of(List.of(String,...))</code> method passing to it <code>List&lt;string&gt;</code> with attachments bodies encoded by <code>base64</code>. Max 3 attachments per message.
         */
        public Builder attachments(Optional<? extends Attachments> attachments) {
            Utils.checkNotNull(attachments, "attachments");
            this.attachments = attachments;
            return this;
        }


        /**
         * Scheduled future date and time of sending the message (in ISO 8601 format). If missing or null - message will be sent immediately
         */
        public Builder date(OffsetDateTime date) {
            Utils.checkNotNull(date, "date");
            this.date = JsonNullable.of(date);
            return this;
        }

        /**
         * Scheduled future date and time of sending the message (in ISO 8601 format). If missing or null - message will be sent immediately
         */
        public Builder date(JsonNullable<OffsetDateTime> date) {
            Utils.checkNotNull(date, "date");
            this.date = date;
            return this;
        }

        public MmsMessage build() {
            if (date == null) {
                date = _SINGLETON_VALUE_Date.value();
            }

            return new MmsMessage(
                recipients, subject, message,
                attachments, date);
        }


        private static final LazySingletonValue<JsonNullable<OffsetDateTime>> _SINGLETON_VALUE_Date =
                new LazySingletonValue<>(
                        "date",
                        "null",
                        new TypeReference<JsonNullable<OffsetDateTime>>() {});
    }
}
