/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;
import pl.gsmservice.gateway.utils.Utils;

/**
 * PhoneNumberWithCid
 * 
 * <p>An object defining the message recipient telephone number with the message's custom identifier assigned by the User
 */
public class PhoneNumberWithCid {
    /**
     * A telephone number in international format (with a plus sign and the country code at the beginning, e.g. +48 for Poland)
     */
    @JsonProperty("nr")
    private String nr;

    /**
     * Custom message ID assigned by the User
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cid")
    private Optional<String> cid;

    @JsonCreator
    public PhoneNumberWithCid(
            @JsonProperty("nr") String nr,
            @JsonProperty("cid") Optional<String> cid) {
        Utils.checkNotNull(nr, "nr");
        Utils.checkNotNull(cid, "cid");
        this.nr = nr;
        this.cid = cid;
    }
    
    public PhoneNumberWithCid(
            String nr) {
        this(nr, Optional.empty());
    }

    /**
     * A telephone number in international format (with a plus sign and the country code at the beginning, e.g. +48 for Poland)
     */
    @JsonIgnore
    public String nr() {
        return nr;
    }

    /**
     * Custom message ID assigned by the User
     */
    @JsonIgnore
    public Optional<String> cid() {
        return cid;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * A telephone number in international format (with a plus sign and the country code at the beginning, e.g. +48 for Poland)
     */
    public PhoneNumberWithCid withNr(String nr) {
        Utils.checkNotNull(nr, "nr");
        this.nr = nr;
        return this;
    }

    /**
     * Custom message ID assigned by the User
     */
    public PhoneNumberWithCid withCid(String cid) {
        Utils.checkNotNull(cid, "cid");
        this.cid = Optional.ofNullable(cid);
        return this;
    }


    /**
     * Custom message ID assigned by the User
     */
    public PhoneNumberWithCid withCid(Optional<String> cid) {
        Utils.checkNotNull(cid, "cid");
        this.cid = cid;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PhoneNumberWithCid other = (PhoneNumberWithCid) o;
        return 
            Utils.enhancedDeepEquals(this.nr, other.nr) &&
            Utils.enhancedDeepEquals(this.cid, other.cid);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            nr, cid);
    }
    
    @Override
    public String toString() {
        return Utils.toString(PhoneNumberWithCid.class,
                "nr", nr,
                "cid", cid);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String nr;

        private Optional<String> cid = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * A telephone number in international format (with a plus sign and the country code at the beginning, e.g. +48 for Poland)
         */
        public Builder nr(String nr) {
            Utils.checkNotNull(nr, "nr");
            this.nr = nr;
            return this;
        }


        /**
         * Custom message ID assigned by the User
         */
        public Builder cid(String cid) {
            Utils.checkNotNull(cid, "cid");
            this.cid = Optional.ofNullable(cid);
            return this;
        }

        /**
         * Custom message ID assigned by the User
         */
        public Builder cid(Optional<String> cid) {
            Utils.checkNotNull(cid, "cid");
            this.cid = cid;
            return this;
        }

        public PhoneNumberWithCid build() {

            return new PhoneNumberWithCid(
                nr, cid);
        }

    }
}
