/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;
import pl.gsmservice.gateway.utils.HasSecurity;
import pl.gsmservice.gateway.utils.SpeakeasyMetadata;
import pl.gsmservice.gateway.utils.Utils;


public class Security implements HasSecurity {

    @SpeakeasyMetadata("security:scheme=true,type=http,subtype=bearer,name=Authorization")
    private Optional<String> bearer;

    @JsonCreator
    public Security(
            Optional<String> bearer) {
        Utils.checkNotNull(bearer, "bearer");
        this.bearer = bearer;
    }
    
    public Security() {
        this(Optional.empty());
    }

    @JsonIgnore
    public Optional<String> bearer() {
        return bearer;
    }

    public static Builder builder() {
        return new Builder();
    }


    public Security withBearer(String bearer) {
        Utils.checkNotNull(bearer, "bearer");
        this.bearer = Optional.ofNullable(bearer);
        return this;
    }


    public Security withBearer(Optional<String> bearer) {
        Utils.checkNotNull(bearer, "bearer");
        this.bearer = bearer;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Security other = (Security) o;
        return 
            Utils.enhancedDeepEquals(this.bearer, other.bearer);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            bearer);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Security.class,
                "bearer", bearer);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> bearer = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder bearer(String bearer) {
            Utils.checkNotNull(bearer, "bearer");
            this.bearer = Optional.ofNullable(bearer);
            return this;
        }

        public Builder bearer(Optional<String> bearer) {
            Utils.checkNotNull(bearer, "bearer");
            this.bearer = bearer;
            return this;
        }

        public Security build() {

            return new Security(
                bearer);
        }

    }
}
