/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the <code>Optional</code> appropriately).
 *
 */
/**
 * SmsType
 * 
 * <p>SMS type (SmsType.SmsPro -&gt; SMS PRO, SmsType.SmsEco -&gt; SMS ECO, SmsType.SmsTwoWay -&gt; SMS 2WAY)
 */
@JsonDeserialize(using = SmsType._Deserializer.class)
@JsonSerialize(using = SmsType._Serializer.class)
public class SmsType {

    public static final SmsType SmsPro = new SmsType(1L);
    public static final SmsType SmsEco = new SmsType(3L);
    public static final SmsType SmsTwoWay = new SmsType(4L);

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<Long, SmsType> values = createValuesMap();
    private static final Map<Long, SmsTypeEnum> enums = createEnumsMap();

    private final long value;

    private SmsType(long value) {
        this.value = value;
    }

    /**
     * Returns a SmsType with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as SmsType
     */ 
    public static SmsType of(long value) {
        synchronized (SmsType.class) {
            return values.computeIfAbsent(value, v -> new SmsType(v));
        }
    }

    public long value() {
        return value;
    }

    public Optional<SmsTypeEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SmsType other = (SmsType) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "SmsType [value=" + value + "]";
    }

    // return an array just like an enum
    public static SmsType[] values() {
        synchronized (SmsType.class) {
            return values.values().toArray(new SmsType[] {});
        }
    }

    private static final Map<Long, SmsType> createValuesMap() {
        Map<Long, SmsType> map = new LinkedHashMap<>();
        map.put(1L, SmsPro);
        map.put(3L, SmsEco);
        map.put(4L, SmsTwoWay);
        return map;
    }

    private static final Map<Long, SmsTypeEnum> createEnumsMap() {
        Map<Long, SmsTypeEnum> map = new HashMap<>();
        map.put(1L, SmsTypeEnum.SmsPro);
        map.put(3L, SmsTypeEnum.SmsEco);
        map.put(4L, SmsTypeEnum.SmsTwoWay);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<SmsType> {

        protected _Serializer() {
            super(SmsType.class);
        }

        @Override
        public void serialize(SmsType value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<SmsType> {

        protected _Deserializer() {
            super(SmsType.class);
        }

        @Override
        public SmsType deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            long v = p.readValueAs(new TypeReference<Long>() {});
            // use the factory method to ensure we get singletons
            return SmsType.of(v);
        }
    }
    
    public enum SmsTypeEnum {

        SmsPro(1L),
        SmsEco(3L),
        SmsTwoWay(4L),;

        private final long value;

        private SmsTypeEnum(long value) {
            this.value = value;
        }

        public long value() {
            return value;
        }
    }
}

