/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.models.operations;

import static pl.gsmservice.gateway.operations.Operations.RequestOperation;

import java.lang.Exception;
import java.lang.Long;
import java.util.List;
import java.util.Optional;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.operations.GetMessages;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.Utils;

public class GetMessagesRequestBuilder {

    private List<Long> ids;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public GetMessagesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetMessagesRequestBuilder ids(List<Long> ids) {
        Utils.checkNotNull(ids, "ids");
        this.ids = ids;
        return this;
    }
                
    public GetMessagesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetMessagesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private GetMessagesRequest buildRequest() {

        GetMessagesRequest request = new GetMessagesRequest(ids);

        return request;
    }

    public GetMessagesResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        RequestOperation<GetMessagesRequest, GetMessagesResponse> operation
              = new GetMessages.Sync(sdkConfiguration, options, _headers);
        GetMessagesRequest request = buildRequest();

        return operation.handleResponse(operation.doRequest(request));
    }
}
