/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.models.operations;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import pl.gsmservice.gateway.models.components.MmsMessage;
import pl.gsmservice.gateway.utils.OneOfDeserializer;
import pl.gsmservice.gateway.utils.TypedObject;
import pl.gsmservice.gateway.utils.Utils.JsonShape;
import pl.gsmservice.gateway.utils.Utils.TypeReferenceWithShape;
import pl.gsmservice.gateway.utils.Utils;

/**
 * GetMmsPriceRequestBody
 * 
 * <p>To check the price of a single message or messages with the same content to multiple recipients, pass a single <code>MmsMessage</code> object with the properties of this message using <code>GetMmsPriceRequestBody.of(MmsMessage)</code> method. To check the price of multiple messages with different content at the same time, pass a <code>List&lt;SmsMessage&gt;</code> with the properties of each message using <code>GetMmsPriceRequestBody.of(List.of(MmsMessage,...))</code> method.
 */
@JsonDeserialize(using = GetMmsPriceRequestBody._Deserializer.class)
public class GetMmsPriceRequestBody {

    @JsonValue
    private TypedObject value;
    
    private GetMmsPriceRequestBody(TypedObject value) {
        this.value = value;
    }

    public static GetMmsPriceRequestBody of(MmsMessage value) {
        Utils.checkNotNull(value, "value");
        return new GetMmsPriceRequestBody(TypedObject.of(value, JsonShape.DEFAULT, new TypeReference<MmsMessage>(){}));
    }

    public static GetMmsPriceRequestBody of(List<MmsMessage> value) {
        Utils.checkNotNull(value, "value");
        return new GetMmsPriceRequestBody(TypedObject.of(value, JsonShape.DEFAULT, new TypeReference<List<MmsMessage>>(){}));
    }
    
    /**
     * Returns an instance of one of these types:
     * <ul>
     * <li>{@code pl.gsmservice.gateway.models.components.MmsMessage}</li>
     * <li>{@code java.util.List<pl.gsmservice.gateway.models.components.MmsMessage>}</li>
     * </ul>
     * 
     * <p>Use {@code instanceof} to determine what type is returned. For example:
     * 
     * <pre>
     * if (obj.value() instanceof String) {
     *     String answer = (String) obj.value();
     *     System.out.println("answer=" + answer);
     * }
     * </pre>
     * 
     * @return value of oneOf type
     **/ 
    public java.lang.Object value() {
        return value.value();
    }    
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetMmsPriceRequestBody other = (GetMmsPriceRequestBody) o;
        return Utils.enhancedDeepEquals(this.value.value(), other.value.value()); 
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(value.value());
    }
    
    @SuppressWarnings("serial")
    public static final class _Deserializer extends OneOfDeserializer<GetMmsPriceRequestBody> {

        public _Deserializer() {
            super(GetMmsPriceRequestBody.class, false,
                  TypeReferenceWithShape.of(new TypeReference<List<MmsMessage>>() {}, JsonShape.DEFAULT),
                  TypeReferenceWithShape.of(new TypeReference<MmsMessage>() {}, JsonShape.DEFAULT));
        }
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetMmsPriceRequestBody.class,
                "value", value);
    }
 
}

