/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.models.operations;

import static pl.gsmservice.gateway.operations.Operations.RequestOperation;

import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.Exception;
import java.lang.Long;
import java.util.Optional;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.operations.ListIncomingMessages;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.LazySingletonValue;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.Utils;

public class ListIncomingMessagesRequestBuilder {

    private Optional<Long> page = Utils.readDefaultOrConstValue(
                            "page",
                            "1",
                            new TypeReference<Optional<Long>>() {});
    private Optional<Long> limit = Utils.readDefaultOrConstValue(
                            "limit",
                            "10",
                            new TypeReference<Optional<Long>>() {});
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public ListIncomingMessagesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }
                
    public ListIncomingMessagesRequestBuilder page(long page) {
        Utils.checkNotNull(page, "page");
        this.page = Optional.of(page);
        return this;
    }

    public ListIncomingMessagesRequestBuilder page(Optional<Long> page) {
        Utils.checkNotNull(page, "page");
        this.page = page;
        return this;
    }
                
    public ListIncomingMessagesRequestBuilder limit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.of(limit);
        return this;
    }

    public ListIncomingMessagesRequestBuilder limit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }
                
    public ListIncomingMessagesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public ListIncomingMessagesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private ListIncomingMessagesRequest buildRequest() {
        if (page == null) {
            page = _SINGLETON_VALUE_Page.value();
        }
        if (limit == null) {
            limit = _SINGLETON_VALUE_Limit.value();
        }

        ListIncomingMessagesRequest request = new ListIncomingMessagesRequest(page,
            limit);

        return request;
    }

    public ListIncomingMessagesResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        RequestOperation<ListIncomingMessagesRequest, ListIncomingMessagesResponse> operation
              = new ListIncomingMessages.Sync(sdkConfiguration, options, _headers);
        ListIncomingMessagesRequest request = buildRequest();

        return operation.handleResponse(operation.doRequest(request));
    }

    private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Page =
            new LazySingletonValue<>(
                    "page",
                    "1",
                    new TypeReference<Optional<Long>>() {});

    private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit =
            new LazySingletonValue<>(
                    "limit",
                    "10",
                    new TypeReference<Optional<Long>>() {});
}
