/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.models.operations;

import static pl.gsmservice.gateway.operations.Operations.RequestOperation;

import java.lang.Exception;
import java.util.Optional;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.operations.SendMms;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.Utils;

public class SendMmsRequestBuilder {

    private SendMmsRequestBody request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public SendMmsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public SendMmsRequestBuilder request(SendMmsRequestBody request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }
                
    public SendMmsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public SendMmsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public SendMmsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        RequestOperation<SendMmsRequestBody, SendMmsResponse> operation
              = new SendMms.Sync(sdkConfiguration, options, _headers);

        return operation.handleResponse(operation.doRequest(request));
    }
}
