/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.models.operations.async;

import static pl.gsmservice.gateway.operations.Operations.AsyncRequestOperation;

import java.lang.Exception;
import java.lang.Long;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.models.operations.CancelMessagesRequest;
import pl.gsmservice.gateway.operations.CancelMessages;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.Utils;

public class CancelMessagesRequestBuilder {

    private List<Long> ids;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public CancelMessagesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CancelMessagesRequestBuilder ids(List<Long> ids) {
        Utils.checkNotNull(ids, "ids");
        this.ids = ids;
        return this;
    }
                
    public CancelMessagesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public CancelMessagesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private CancelMessagesRequest buildRequest() {

        CancelMessagesRequest request = new CancelMessagesRequest(ids);

        return request;
    }

    public CompletableFuture<CancelMessagesResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<CancelMessagesRequest, CancelMessagesResponse> operation
              = new CancelMessages.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        CancelMessagesRequest request = buildRequest();

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }
}
