/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import pl.gsmservice.gateway.models.components.CancelledMessage;
import pl.gsmservice.gateway.utils.AsyncResponse;
import pl.gsmservice.gateway.utils.Blob;
import pl.gsmservice.gateway.utils.Utils;


public class CancelMessagesResponse implements AsyncResponse {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<Blob> rawResponse;

    /**
     * The request was processed successfully. Please check the status of messages cancellation in <code>status</code> property of each <code>CancelledMessage</code> object.
     */
    private Optional<? extends List<CancelledMessage>> cancelledMessages;


    private Map<String, List<String>> headers;

    @JsonCreator
    public CancelMessagesResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Optional<? extends List<CancelledMessage>> cancelledMessages,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(cancelledMessages, "cancelledMessages");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.cancelledMessages = cancelledMessages;
        this.headers = headers;
    }
    
    public CancelMessagesResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse,
            Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return rawResponse;
    }

    /**
     * The request was processed successfully. Please check the status of messages cancellation in <code>status</code> property of each <code>CancelledMessage</code> object.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<CancelledMessage>> cancelledMessages() {
        return (Optional<List<CancelledMessage>>) cancelledMessages;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public CancelMessagesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public CancelMessagesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public CancelMessagesResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The request was processed successfully. Please check the status of messages cancellation in <code>status</code> property of each <code>CancelledMessage</code> object.
     */
    public CancelMessagesResponse withCancelledMessages(List<CancelledMessage> cancelledMessages) {
        Utils.checkNotNull(cancelledMessages, "cancelledMessages");
        this.cancelledMessages = Optional.ofNullable(cancelledMessages);
        return this;
    }


    /**
     * The request was processed successfully. Please check the status of messages cancellation in <code>status</code> property of each <code>CancelledMessage</code> object.
     */
    public CancelMessagesResponse withCancelledMessages(Optional<? extends List<CancelledMessage>> cancelledMessages) {
        Utils.checkNotNull(cancelledMessages, "cancelledMessages");
        this.cancelledMessages = cancelledMessages;
        return this;
    }

    public CancelMessagesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CancelMessagesResponse other = (CancelMessagesResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.cancelledMessages, other.cancelledMessages) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            cancelledMessages, headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CancelMessagesResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "cancelledMessages", cancelledMessages,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<Blob> rawResponse;

        private Optional<? extends List<CancelledMessage>> cancelledMessages = Optional.empty();

        private Map<String, List<String>> headers;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * The request was processed successfully. Please check the status of messages cancellation in <code>status</code> property of each <code>CancelledMessage</code> object.
         */
        public Builder cancelledMessages(List<CancelledMessage> cancelledMessages) {
            Utils.checkNotNull(cancelledMessages, "cancelledMessages");
            this.cancelledMessages = Optional.ofNullable(cancelledMessages);
            return this;
        }

        /**
         * The request was processed successfully. Please check the status of messages cancellation in <code>status</code> property of each <code>CancelledMessage</code> object.
         */
        public Builder cancelledMessages(Optional<? extends List<CancelledMessage>> cancelledMessages) {
            Utils.checkNotNull(cancelledMessages, "cancelledMessages");
            this.cancelledMessages = cancelledMessages;
            return this;
        }


        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public CancelMessagesResponse build() {

            return new CancelMessagesResponse(
                contentType, statusCode, rawResponse,
                cancelledMessages, headers);
        }

    }
}
