/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.Optional;
import pl.gsmservice.gateway.models.components.AccountResponse;
import pl.gsmservice.gateway.utils.AsyncResponse;
import pl.gsmservice.gateway.utils.Blob;
import pl.gsmservice.gateway.utils.Utils;


public class GetAccountDetailsResponse implements AsyncResponse {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<Blob> rawResponse;

    /**
     * The request was processed successfully
     */
    private Optional<? extends AccountResponse> accountResponse;

    @JsonCreator
    public GetAccountDetailsResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Optional<? extends AccountResponse> accountResponse) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(accountResponse, "accountResponse");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.accountResponse = accountResponse;
    }
    
    public GetAccountDetailsResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse) {
        this(contentType, statusCode, rawResponse,
            Optional.empty());
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return rawResponse;
    }

    /**
     * The request was processed successfully
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<AccountResponse> accountResponse() {
        return (Optional<AccountResponse>) accountResponse;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public GetAccountDetailsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public GetAccountDetailsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public GetAccountDetailsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The request was processed successfully
     */
    public GetAccountDetailsResponse withAccountResponse(AccountResponse accountResponse) {
        Utils.checkNotNull(accountResponse, "accountResponse");
        this.accountResponse = Optional.ofNullable(accountResponse);
        return this;
    }


    /**
     * The request was processed successfully
     */
    public GetAccountDetailsResponse withAccountResponse(Optional<? extends AccountResponse> accountResponse) {
        Utils.checkNotNull(accountResponse, "accountResponse");
        this.accountResponse = accountResponse;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetAccountDetailsResponse other = (GetAccountDetailsResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.accountResponse, other.accountResponse);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            accountResponse);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetAccountDetailsResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "accountResponse", accountResponse);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<Blob> rawResponse;

        private Optional<? extends AccountResponse> accountResponse = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * The request was processed successfully
         */
        public Builder accountResponse(AccountResponse accountResponse) {
            Utils.checkNotNull(accountResponse, "accountResponse");
            this.accountResponse = Optional.ofNullable(accountResponse);
            return this;
        }

        /**
         * The request was processed successfully
         */
        public Builder accountResponse(Optional<? extends AccountResponse> accountResponse) {
            Utils.checkNotNull(accountResponse, "accountResponse");
            this.accountResponse = accountResponse;
            return this;
        }

        public GetAccountDetailsResponse build() {

            return new GetAccountDetailsResponse(
                contentType, statusCode, rawResponse,
                accountResponse);
        }

    }
}
