/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.models.operations.async;

import static pl.gsmservice.gateway.operations.Operations.AsyncRequestOperation;

import java.lang.Exception;
import java.lang.Long;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.models.operations.GetIncomingMessagesRequest;
import pl.gsmservice.gateway.operations.GetIncomingMessages;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.Utils;

public class GetIncomingMessagesRequestBuilder {

    private List<Long> ids;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public GetIncomingMessagesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetIncomingMessagesRequestBuilder ids(List<Long> ids) {
        Utils.checkNotNull(ids, "ids");
        this.ids = ids;
        return this;
    }
                
    public GetIncomingMessagesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetIncomingMessagesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private GetIncomingMessagesRequest buildRequest() {

        GetIncomingMessagesRequest request = new GetIncomingMessagesRequest(ids);

        return request;
    }

    public CompletableFuture<GetIncomingMessagesResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<GetIncomingMessagesRequest, GetIncomingMessagesResponse> operation
              = new GetIncomingMessages.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        GetIncomingMessagesRequest request = buildRequest();

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }
}
