/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import pl.gsmservice.gateway.models.components.IncomingMessage;
import pl.gsmservice.gateway.utils.AsyncResponse;
import pl.gsmservice.gateway.utils.Blob;
import pl.gsmservice.gateway.utils.Utils;


public class ListIncomingMessagesResponse implements AsyncResponse {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<Blob> rawResponse;

    /**
     * The request was processed successfully. Please check received message details in each <code>IncomingMessage</code> object
     */
    private Optional<? extends List<IncomingMessage>> incomingMessages;


    private Map<String, List<String>> headers;

    @JsonCreator
    public ListIncomingMessagesResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Optional<? extends List<IncomingMessage>> incomingMessages,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(incomingMessages, "incomingMessages");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.incomingMessages = incomingMessages;
        this.headers = headers;
    }
    
    public ListIncomingMessagesResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse,
            Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return rawResponse;
    }

    /**
     * The request was processed successfully. Please check received message details in each <code>IncomingMessage</code> object
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<IncomingMessage>> incomingMessages() {
        return (Optional<List<IncomingMessage>>) incomingMessages;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public ListIncomingMessagesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public ListIncomingMessagesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public ListIncomingMessagesResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The request was processed successfully. Please check received message details in each <code>IncomingMessage</code> object
     */
    public ListIncomingMessagesResponse withIncomingMessages(List<IncomingMessage> incomingMessages) {
        Utils.checkNotNull(incomingMessages, "incomingMessages");
        this.incomingMessages = Optional.ofNullable(incomingMessages);
        return this;
    }


    /**
     * The request was processed successfully. Please check received message details in each <code>IncomingMessage</code> object
     */
    public ListIncomingMessagesResponse withIncomingMessages(Optional<? extends List<IncomingMessage>> incomingMessages) {
        Utils.checkNotNull(incomingMessages, "incomingMessages");
        this.incomingMessages = incomingMessages;
        return this;
    }

    public ListIncomingMessagesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListIncomingMessagesResponse other = (ListIncomingMessagesResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.incomingMessages, other.incomingMessages) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            incomingMessages, headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ListIncomingMessagesResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "incomingMessages", incomingMessages,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<Blob> rawResponse;

        private Optional<? extends List<IncomingMessage>> incomingMessages = Optional.empty();

        private Map<String, List<String>> headers;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * The request was processed successfully. Please check received message details in each <code>IncomingMessage</code> object
         */
        public Builder incomingMessages(List<IncomingMessage> incomingMessages) {
            Utils.checkNotNull(incomingMessages, "incomingMessages");
            this.incomingMessages = Optional.ofNullable(incomingMessages);
            return this;
        }

        /**
         * The request was processed successfully. Please check received message details in each <code>IncomingMessage</code> object
         */
        public Builder incomingMessages(Optional<? extends List<IncomingMessage>> incomingMessages) {
            Utils.checkNotNull(incomingMessages, "incomingMessages");
            this.incomingMessages = incomingMessages;
            return this;
        }


        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public ListIncomingMessagesResponse build() {

            return new ListIncomingMessagesResponse(
                contentType, statusCode, rawResponse,
                incomingMessages, headers);
        }

    }
}
