/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.Optional;
import pl.gsmservice.gateway.utils.AsyncResponse;
import pl.gsmservice.gateway.utils.Blob;
import pl.gsmservice.gateway.utils.Utils;


public class PingResponse implements AsyncResponse {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<Blob> rawResponse;

    /**
     * API service is available
     */
    private Optional<? extends pl.gsmservice.gateway.models.components.PingResponse> pingResponse;

    @JsonCreator
    public PingResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Optional<? extends pl.gsmservice.gateway.models.components.PingResponse> pingResponse) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(pingResponse, "pingResponse");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.pingResponse = pingResponse;
    }
    
    public PingResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse) {
        this(contentType, statusCode, rawResponse,
            Optional.empty());
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return rawResponse;
    }

    /**
     * API service is available
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<pl.gsmservice.gateway.models.components.PingResponse> pingResponse() {
        return (Optional<pl.gsmservice.gateway.models.components.PingResponse>) pingResponse;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public PingResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public PingResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public PingResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * API service is available
     */
    public PingResponse withPingResponse(pl.gsmservice.gateway.models.components.PingResponse pingResponse) {
        Utils.checkNotNull(pingResponse, "pingResponse");
        this.pingResponse = Optional.ofNullable(pingResponse);
        return this;
    }


    /**
     * API service is available
     */
    public PingResponse withPingResponse(Optional<? extends pl.gsmservice.gateway.models.components.PingResponse> pingResponse) {
        Utils.checkNotNull(pingResponse, "pingResponse");
        this.pingResponse = pingResponse;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PingResponse other = (PingResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.pingResponse, other.pingResponse);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            pingResponse);
    }
    
    @Override
    public String toString() {
        return Utils.toString(PingResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "pingResponse", pingResponse);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<Blob> rawResponse;

        private Optional<? extends pl.gsmservice.gateway.models.components.PingResponse> pingResponse = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * API service is available
         */
        public Builder pingResponse(pl.gsmservice.gateway.models.components.PingResponse pingResponse) {
            Utils.checkNotNull(pingResponse, "pingResponse");
            this.pingResponse = Optional.ofNullable(pingResponse);
            return this;
        }

        /**
         * API service is available
         */
        public Builder pingResponse(Optional<? extends pl.gsmservice.gateway.models.components.PingResponse> pingResponse) {
            Utils.checkNotNull(pingResponse, "pingResponse");
            this.pingResponse = pingResponse;
            return this;
        }

        public PingResponse build() {

            return new PingResponse(
                contentType, statusCode, rawResponse,
                pingResponse);
        }

    }
}
