/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.models.operations.async;

import static pl.gsmservice.gateway.operations.Operations.AsyncRequestOperation;

import java.lang.Exception;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.models.operations.SendMmsRequestBody;
import pl.gsmservice.gateway.operations.SendMms;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.Utils;

public class SendMmsRequestBuilder {

    private SendMmsRequestBody request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public SendMmsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public SendMmsRequestBuilder request(SendMmsRequestBody request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }
                
    public SendMmsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public SendMmsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<SendMmsResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<SendMmsRequestBody, SendMmsResponse> operation
              = new SendMms.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }
}
