/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.utils;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

/**
 * Blocking parser that reads from a Reader and delegates to a StreamingParser.
 */
public final class BlockingParser<T> {
    private final Reader reader;
    private final StreamingParser<T> parser;
    private final char[] readBuffer = new char[8192];
    private boolean readerExhausted = false;

    public BlockingParser(Reader reader, StreamingParser<T> parser) {
        this.reader = reader;
        this.parser = parser;
    }

    /**
     * Read the next parsed result from the Reader.
     *
     * @return next complete parsed result, or empty if no more data
     * @throws IOException if reading fails
     */
    public Optional<T> next() throws IOException {
        // First check if we already have a complete result buffered
        Optional<T> result = parser.next();
        if (result.isPresent()) {
            return result;
        }
        // If reader is exhausted, try to get any remaining partial data
        if (readerExhausted) {
            return parser.finish();
        }
        // Read more data until we have a complete result or EOF
        int bytesRead;
        while ((bytesRead = reader.read(readBuffer)) != -1) {
            ByteBuffer chunk = ByteBuffer.wrap(new String(readBuffer, 0, bytesRead).getBytes(StandardCharsets.UTF_8));
            result = parser.add(chunk);
            if (result.isPresent()) {
                return result;
            }
        }
        // Reader is now exhausted
        readerExhausted = true;
        return parser.finish();
    }

    /**
     * Check if there are more results available (either buffered or from reader)
     */
    public boolean hasNext() throws IOException {
        return parser.hasBufferedData() || !readerExhausted;
    }

    /**
     * Close the underlying reader
     */
    public void close() throws IOException {
        reader.close();
    }

    // ===== Factory Methods =====

    /**
     * Create a blocking parser for JSON Lines format
     */
    public static BlockingParser<String> forJsonLines(Reader reader) {
        return new BlockingParser<>(reader, StreamingParser.forJsonLines());
    }

    /**
     * Create a blocking parser for SSE format
     */
    public static BlockingParser<EventStreamMessage> forSSE(Reader reader) {
        return new BlockingParser<>(reader, StreamingParser.forSSE());
    }
}