/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.utils;

import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

/**
 * Utility class for adapting synchronous hooks to asynchronous hooks.
 * <p>
 * This class provides adapter methods that convert synchronous hook implementations
 * ({@link Hook.BeforeRequest}, {@link Hook.AfterSuccess}, {@link Hook.AfterError})
 * to their asynchronous counterparts ({@link AsyncHook.BeforeRequest}, 
 * {@link AsyncHook.AfterSuccess}, {@link AsyncHook.AfterError}).
 * <p>
 * <b>Performance Note:</b> The execution of synchronous hooks is offloaded to the 
 * global {@link java.util.concurrent.ForkJoinPool#commonPool() ForkJoinPool}. 
 * For better performance in high-throughput scenarios, consider re-implementing 
 * hooks using non-blocking I/O (NIO) patterns instead of relying on these adapters.
 * <p>
 * <b>Thread Safety:</b> All adapter methods are thread-safe and can be called 
 * concurrently from multiple threads.
 *
 * @see Hook
 * @see AsyncHook
 * @see java.util.concurrent.ForkJoinPool#commonPool()
 */
public final class HookAdapters {

    private HookAdapters() {
        // prevent instantiation
    }

    /**
     * Adapts a synchronous {@link Hook.BeforeRequest} to an asynchronous
     * {@link AsyncHook.BeforeRequest}.
     * <p>
     * The synchronous hook execution is offloaded to the global
     * {@link java.util.concurrent.ForkJoinPool#commonPool() ForkJoinPool}.
     * Any exceptions thrown by the synchronous hook are wrapped as unchecked
     * exceptions and propagated through the returned {@link CompletableFuture}.
     * <p>
     * <b>Performance Consideration:</b> For high-throughput applications,
     * consider implementing the hook directly using NIO patterns rather than
     * using this adapter, as it avoids thread pool overhead and blocking operations.
     *
     * @param beforeRequestHook the synchronous before-request hook to adapt
     * @return an asynchronous before-request hook that executes the synchronous hook
     *         in the global ForkJoinPool
     * @throws NullPointerException if {@code beforeRequestHook} is {@code null}
     */
    public static AsyncHook.BeforeRequest toAsync(Hook.BeforeRequest beforeRequestHook) {
        return ((context, request) -> CompletableFuture.supplyAsync(
                () -> Exceptions.unchecked(() -> beforeRequestHook.beforeRequest(context, request)).get()));
    }

    /**
     * Adapts a synchronous {@link Hook.AfterError} to an asynchronous
     * {@link AsyncHook.AfterError}.
     * <p>
     * This method handles the conversion between different response body types:
     * <ul>
     *   <li>Converts {@link HttpResponse}&lt;{@link Blob}&gt; to
     *       {@link HttpResponse}&lt;{@link InputStream}&gt; for the synchronous hook</li>
     *   <li>Converts the result back to {@link HttpResponse}&lt;{@link Blob}&gt;
     *       for the asynchronous interface</li>
     * </ul>
     * <p>
     * The synchronous hook execution is <b>offloaded to the global 
     * {@link java.util.concurrent.ForkJoinPool#commonPool() ForkJoinPool}</b>.
     * Any exceptions thrown by the synchronous hook are wrapped as unchecked
     * exceptions and propagated through the returned {@link CompletableFuture}.
     * <p>
     * <b>Performance Consideration:</b> For high-throughput applications,
     * consider implementing the hook directly using NIO patterns rather than
     * using this adapter, as it avoids thread pool overhead and blocking I/O operations.
     *
     * @param afterErrorHook the synchronous after-error hook to adapt
     * @return an asynchronous after-error hook that executes the synchronous hook
     *         in the global ForkJoinPool
     * @throws NullPointerException if {@code afterErrorHook} is {@code null}
     */
    public static AsyncHook.AfterError toAsync(Hook.AfterError afterErrorHook) {
        return (context, response, error) -> toStreamResponse(response)
                .thenCompose(backCompatResp -> {
                    CompletableFuture<HttpResponse<InputStream>> processedResp = CompletableFuture.supplyAsync(() ->
                            Exceptions.unchecked(() ->
                                    afterErrorHook.afterError(
                                            context,
                                            Optional.of(backCompatResp),
                                            Optional.of(Exceptions.coerceException(error)))).get());

                    return processedResp
                            .thenApply(HookAdapters::toBlobResponse);
                });

    }

    /**
     * Adapts a synchronous {@link Hook.AfterSuccess} to an asynchronous
     * {@link AsyncHook.AfterSuccess}.
     * <p>
     * This method handles the conversion between different response body types:
     * <ul>
     *   <li>Converts {@link HttpResponse}&lt;{@link Blob}&gt; to
     *       {@link HttpResponse}&lt;{@link InputStream}&gt; for the synchronous hook</li>
     *   <li>Converts the result back to {@link HttpResponse}&lt;{@link Blob}&gt;
     *       for the asynchronous interface</li>
     * </ul>
     * <p>
     * The synchronous hook execution is <b>offloaded to the global
     * {@link java.util.concurrent.ForkJoinPool#commonPool() ForkJoinPool}</b>.
     * Any exceptions thrown by the synchronous hook are wrapped as unchecked
     * exceptions and propagated through the returned {@link CompletableFuture}.
     * <p>
     * <b>Performance Consideration:</b> For high-throughput applications,
     * consider implementing the hook directly using NIO patterns rather than
     * using this adapter, as it avoids thread pool overhead and blocking I/O operations.
     *
     * @param afterSuccessHook the synchronous after-success hook to adapt
     * @return an asynchronous after-success hook that executes the synchronous hook
     *         in the global ForkJoinPool
     * @throws NullPointerException if {@code afterSuccessHook} is {@code null}
     */
    public static AsyncHook.AfterSuccess toAsync(Hook.AfterSuccess afterSuccessHook) {
        return (context, response) -> toStreamResponse(response)
                .thenCompose(backCompatResp -> {
                    CompletableFuture<HttpResponse<InputStream>> processedResp = CompletableFuture.supplyAsync(() ->
                            Exceptions.unchecked(() ->
                                    afterSuccessHook.afterSuccess(
                                            context,
                                            backCompatResp)).get());

                    return processedResp
                            .thenApply(HookAdapters::toBlobResponse);
                });

    }

    /**
     * Converts an {@link HttpResponse}&lt;{@link InputStream}&gt; to an
     * {@link HttpResponse}&lt;{@link Blob}&gt;.
     * <p>
     * This method wraps the InputStream response body in a {@link Blob} while
     * preserving all other response metadata (status code, headers, etc.).
     * <p>
     * <b>Note:</b> The resulting {@link Blob} is created from the InputStream,
     * which means it may not support retries effectively if the InputStream 
     * gets consumed during the first attempt.
     *
     * @param response the response with InputStream body to convert
     * @return a new response with the same metadata but with a Blob body
     * @throws NullPointerException if {@code response} is {@code null}
     */
    private static HttpResponse<Blob> toBlobResponse(HttpResponse<InputStream> response) {
        return new ResponseWithBody<>(response, Blob.from(response.body()));
    }

    /**
     * Converts an {@link HttpResponse}&lt;{@link Blob}&gt; to an
     * {@link HttpResponse}&lt;{@link InputStream}&gt;.
     * <p>
     * This method asynchronously converts the Blob response body to an InputStream
     * while preserving all other response metadata (status code, headers, etc.).
     * The conversion is performed using {@link Blob#toInputStream()}.
     * <p>
     * <b>Note:</b> This operation consumes the {@link Blob}, making it unavailable
     * for further use after this conversion.
     *
     * @param response the response with Blob body to convert
     * @return a CompletableFuture containing a new response with the same metadata
     *         but with an InputStream body
     * @throws NullPointerException if {@code response} is {@code null}
     */
    private static CompletableFuture<HttpResponse<InputStream>> toStreamResponse(HttpResponse<Blob> response) {
        return response.body().toInputStream().thenApply(body -> new ResponseWithBody<>(response, body));
    }
}