/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.utils;

import pl.gsmservice.gateway.utils.reactive.ReactiveUtils;

import java.net.URLEncoder;
import java.net.http.HttpRequest.BodyPublisher;
import java.net.http.HttpRequest.BodyPublishers;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.concurrent.Flow;

public final class Multipart {

    private static final String CRLF = "\r\n";
    private static final String DASHES = "--";
    private static final Charset HDR_CS = StandardCharsets.ISO_8859_1; // headers
    private static final Charset TXT_CS = StandardCharsets.UTF_8;      // text fields
    private static final String DEFAULT_FILE_CT = "application/octet-stream";
    public static final String DEFAULT_TEXT_CT = "text/plain; charset=UTF-8";

    private final BodyPublisher bodyPublisher;
    private final String boundary;

    private Multipart(BodyPublisher bodyPublisher, String boundary) {
        this.bodyPublisher = bodyPublisher;
        this.boundary = boundary;
    }

    public BodyPublisher bodyPublisher() {
        return bodyPublisher;
    }

    /**
     * Visible for tests.
     */
    public String boundary() {
        return boundary;
    }

    /**
     * RFC 7578: no charset parameter at the multipart level.
     */
    public String contentType() {
        return "multipart/form-data; boundary=" + boundary;
    }

    public static Builder builder() {
        return new Builder();
    }

    // -------------------------------------------------------
    // Builder
    // -------------------------------------------------------
    public static final class Builder {
        private final List<Part> parts = new ArrayList<>();
        private final String boundary = UUID.randomUUID().toString();

        public Builder addPart(String name, String value) {
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(value, "value");
            parts.add(new FormField(name, value, DEFAULT_TEXT_CT));
            return this;
        }

        public Builder addPart(String name, String value, String contentType) {
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(value, "value");
            Utils.checkNotNull(contentType, "contentType");
            parts.add(new FormField(name, value, contentType));
            return this;
        }

        public Builder addPart(String name, byte[] bytes, String filename, String contentType) {
            return addPart(name, Blob.from(bytes), filename, contentType);
        }

        public Builder addPart(String name, Blob blob, String filename, String contentType) {
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(blob, "blob");
            Utils.checkNotNull(filename, "filename");
            parts.add(new FilePart(name, blob, filename,
                    Optional.ofNullable(contentType).orElse(DEFAULT_FILE_CT)));
            return this;
        }

        public Multipart build() {
            if (parts.isEmpty()) {
                throw new IllegalStateException("Must have at least one part to build multipart message.");
            }

            // Build publishers for each part plus the closing boundary.
            List<BodyPublisher> pubs = new ArrayList<>(parts.size() + 1);
            for (Part p : parts) {
                pubs.add(p.toPublisher(boundary));
            }
            pubs.add(BodyPublishers.ofString(DASHES + boundary + DASHES + CRLF, HDR_CS));

            BodyPublisher multipart = concat(pubs);
            return new Multipart(multipart, boundary);
        }
    }

    // -------------------------------------------------------
    // Part model
    // -------------------------------------------------------
    interface Part {
        BodyPublisher toPublisher(String boundary);
    }

    /**
     * Text form field.
     */
    static final class FormField implements Part {
        private final String name;
        private final String value;
        private final String contentType;

        FormField(String name, String value, String contentType) {
            this.name = name;
            this.value = value;
            this.contentType = contentType != null ? contentType : "text/plain; charset=UTF-8";
        }

        @Override
        public BodyPublisher toPublisher(String boundary) {
            String header = DASHES + boundary + CRLF +
                    "Content-Disposition: form-data; name=\"" + escapeQuoted(name) + "\"" + CRLF +
                    "Content-Type: " + contentType + CRLF +
                    CRLF;

            BodyPublisher h = BodyPublishers.ofString(header, HDR_CS);
            BodyPublisher b = BodyPublishers.ofString(value, TXT_CS);
            BodyPublisher t = BodyPublishers.ofString(CRLF, HDR_CS);

            return concat(h, b, t);
        }
    }

    /**
     * File / blob upload.
     */
    static final class FilePart implements Part {
        private final String name;
        private final String filename;
        private final String contentType;
        private final Blob blob;

        FilePart(String name, Blob blob, String filename, String contentType) {
            this.name = name;
            this.filename = filename;
            this.contentType = contentType != null ? contentType : DEFAULT_FILE_CT;
            this.blob = blob;
        }

        @Override
        public BodyPublisher toPublisher(String boundary) {
            String cd = contentDispositionWithFilename(name, filename);
            String header = DASHES + boundary + CRLF +
                    "Content-Disposition: " + cd + CRLF +
                    "Content-Type: " + contentType + CRLF +
                    CRLF;

            BodyPublisher h = BodyPublishers.ofString(header, HDR_CS);
            BodyPublisher c = BodyPublishers.fromPublisher(blob.asPublisher()); // streaming
            BodyPublisher t = BodyPublishers.ofString(CRLF, HDR_CS);

            return concat(h, c, t);
        }
    }

    // -------------------------------------------------------
    // Helpers
    // -------------------------------------------------------
    private static String escapeQuoted(String s) {
        Objects.requireNonNull(s, "quoted string");
        StringBuilder out = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); i++) {
            char c = s.charAt(i);
            if (c == '"' || c == '\\') out.append('\\').append(c);
            else if (c == '\r' || c == '\n') out.append(' ');
            else out.append(c);
        }
        return out.toString();
    }

    /**
     * RFC 5987 filename* with ASCII fallback.
     */
    private static String contentDispositionWithFilename(String name, String filename) {
        String safeName = escapeQuoted(name);
        String fallback = escapeQuoted(asAsciiFilenameFallback(filename));
        String encoded;
        try {
            encoded = URLEncoder.encode(filename, TXT_CS).replace("+", "%20");
        } catch (Exception e) {
            encoded = fallback;
        }
        return "form-data; name=\"" + safeName + "\"; filename=\"" + fallback + "\"; filename*=UTF-8''" + encoded;
    }

    private static String asAsciiFilenameFallback(String filename) {
        StringBuilder sb = new StringBuilder(filename.length());
        for (int i = 0; i < filename.length(); i++) {
            char c = filename.charAt(i);
            if (c >= 0x20 && c <= 0x7E && c != '"' && c != '\\') sb.append(c);
            else sb.append('_');
        }
        return sb.toString();
    }

    private static BodyPublisher concat(BodyPublisher... publishers) {
        return BodyPublishers.fromPublisher(ReactiveUtils.concat(List.of(publishers)));
    }

    private static BodyPublisher concat(List<BodyPublisher> publishers) {
        List<Flow.Publisher<ByteBuffer>> bufferPublishers = List.copyOf(publishers);
        return BodyPublishers.fromPublisher(ReactiveUtils.concat(bufferPublishers));
    }

}
