/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.utils;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

// INTERNAL API ONLY

public class Reflections {

    /**
     * Extracts the underlying value from an open enum instance if the class follows the open enum pattern.
     *
     * <p>An open enum is a class that emulates enum behavior but can handle unknown values
     * without runtime errors. This pattern is commonly used for API responses where new
     * enum values might be added over time.
     *
     * <p>The method validates that the class follows the open enum pattern by checking for:
     * <ul>
     *   <li>A static factory method {@code of(String)} or {@code of(Integer)} that returns the class type</li>
     *   <li>An instance method {@code value()} returning String or Integer</li>
     *   <li>At least one public static final field of the same class type (predefined constants)</li>
     * </ul>
     *
     * <p>If all validation passes, the method invokes the {@code value()} method on the provided instance
     * and returns the result.
     *
     * @param clazz    the class to examine for open enum pattern
     * @param instance the instance of the open enum class from which to extract the value
     * @return {@code Optional<?>} containing the extracted value (String or Integer) if the class
     * follows the open enum pattern and the value extraction succeeds, {@code Optional.empty()} otherwise
     */
    public static Optional<?> getOpenEnumValue(Class<?> clazz, Object instance) {
        Objects.requireNonNull(clazz, "Class cannot be null");

        try {
            // Check for factory method of(String) or of(Integer)
            boolean hasFactoryMethod = Arrays.stream(clazz.getDeclaredMethods())
                    .anyMatch(method -> isValidFactoryMethod(method, clazz));
            if (!hasFactoryMethod) {
                return Optional.empty();
            }

            // Check for at least one static constant of same type
            if (!hasStaticConstants(clazz)) {
                return Optional.empty();
            }

            // Check for value() method returning String or Integer
            Method valueMethod = clazz.getMethod("value");
            if (!isValidValueMethod(valueMethod)) {
                return Optional.empty();
            }

            valueMethod.setAccessible(true);
            return Optional.of(valueMethod.invoke(instance));
        } catch (Exception e) {
            return Optional.empty();
        }
    }

    private static boolean isNumericType(Class<?> type) {
        // Primitive numeric types
        if (type.isPrimitive()) {
            return type == byte.class || type == short.class ||
                    type == int.class || type == long.class ||
                    type == float.class || type == double.class;
        }

        // Number subclasses (Integer, Long, Double, BigDecimal, etc.)
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }

        // Atomic numeric types
        return type == AtomicInteger.class || type == AtomicLong.class;
    }

    /**
     * Checks if the given method is a valid factory method for an open enum.
     *
     * @param method the method to check
     * @param clazz  the class that should be returned by the factory method
     * @return true if valid factory method
     */
    private static boolean isValidFactoryMethod(Method method, Class<?> clazz) {
        // Must be named "of"
        if (!"of".equals(method.getName())) {
            return false;
        }

        // Must be static and return the enum class
        if (!Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(clazz)) {
            return false;
        }

        // Must have exactly one parameter of String or Integer type
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length == 1 &&
                (String.class.equals(parameterTypes[0]) || isNumericType(parameterTypes[0]));
    }

    /**
     * Checks if the given method is a valid value() method for an open enum.
     *
     * @param method the value() method to validate
     * @return true if valid value method
     */
    private static boolean isValidValueMethod(Method method) {
        // Must not be static and return String or Integer
        return !Modifier.isStatic(method.getModifiers()) &&
                (String.class.equals(method.getReturnType()) || isNumericType(method.getReturnType()));
    }

    /**
     * Checks if the class has at least one public static final field of the same class type.
     *
     * @param clazz the class to check for static constants
     * @return true if has static constants
     */
    private static boolean hasStaticConstants(Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredFields())
                .anyMatch(field -> {
                    int modifiers = field.getModifiers();
                    return Modifier.isStatic(modifiers) &&
                            Modifier.isFinal(modifiers) &&
                            Modifier.isPublic(modifiers) &&
                            clazz.equals(field.getType());
                });
    }
}
