/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package pl.gsmservice.gateway.utils;

import javax.net.ssl.SSLSession;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.function.Function;

/**
 * A wrapper for {@link HttpResponse} that allows mappi ng the response body from type {@code R} to type {@code B}.
 * <p>
 * This class delegates all methods to the original response, except for {@link #body()}, which returns the mapped body.
 * The mapping is performed using the provided {@code bodyMapper} function at construction time.
 *
 * @param <R> the type of the original response body
 * @param <B> the type of the mapped response body
 */
public class ResponseWithBody<R, B> implements HttpResponse<B> {
    private final HttpResponse<R> original;
    private final Function<R, B> bodyMapper;
    private final B body;

    /**
     * Constructs a new {@code ResponseWithBody} by wrapping an existing {@link HttpResponse} and applying
     * a mapping function to its body.
     *
     * @param original   the original response to wrap
     * @param bodyMapper a function to map the original body to the new body type
     */
    public ResponseWithBody(HttpResponse<R> original, Function<R, B> bodyMapper) {
        this.original = original;
        this.bodyMapper = bodyMapper;
        this.body = bodyMapper.apply(original.body());
    }

    /**
     * Constructs a new {@code ResponseWithBody} by wrapping an existing {@link HttpResponse} with
     * a pre-computed body value.
     *
     * @param original the original response to wrap
     * @param body     the pre-computed body value
     */
    public ResponseWithBody(HttpResponse<R> original, B body) {
        this.original = original;
        this.body = body;
        this.bodyMapper = null;
    }

    @Override
    public int statusCode() {
        return original.statusCode();
    }

    @Override
    public HttpRequest request() {
        return original.request();
    }

    @Override
    public Optional<HttpResponse<B>> previousResponse() {
        return original.previousResponse()
                .map(prev -> new ResponseWithBody<>(prev, bodyMapper));
    }

    @Override
    public HttpHeaders headers() {
        return original.headers();
    }

    @Override
    public B body() {
        return body;
    }

    @Override
    public Optional<SSLSession> sslSession() {
        return original.sslSession();
    }

    @Override
    public URI uri() {
        return original.uri();
    }

    @Override
    public HttpClient.Version version() {
        return original.version();
    }
}
