/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway;

import java.util.Optional;
import pl.gsmservice.gateway.AsyncAccounts;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.models.operations.GetAccountDetailsRequestBuilder;
import pl.gsmservice.gateway.models.operations.GetAccountDetailsResponse;
import pl.gsmservice.gateway.models.operations.GetSubaccountDetailsRequest;
import pl.gsmservice.gateway.models.operations.GetSubaccountDetailsRequestBuilder;
import pl.gsmservice.gateway.models.operations.GetSubaccountDetailsResponse;
import pl.gsmservice.gateway.operations.GetAccountDetails;
import pl.gsmservice.gateway.operations.GetSubaccountDetails;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;

public class Accounts {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncAccounts asyncSDK;

    Accounts(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncAccounts(this, sdkConfiguration);
    }

    public AsyncAccounts async() {
        return this.asyncSDK;
    }

    public GetAccountDetailsRequestBuilder get() {
        return new GetAccountDetailsRequestBuilder(this.sdkConfiguration);
    }

    public GetAccountDetailsResponse getDirect() throws Exception {
        return this.get(Optional.empty());
    }

    public GetAccountDetailsResponse get(Optional<Options> options) throws Exception {
        GetAccountDetails.Sync operation = new GetAccountDetails.Sync(this.sdkConfiguration, options, _headers);
        return (GetAccountDetailsResponse)operation.handleResponse(operation.doRequest());
    }

    public GetSubaccountDetailsRequestBuilder getSubaccount() {
        return new GetSubaccountDetailsRequestBuilder(this.sdkConfiguration);
    }

    public GetSubaccountDetailsResponse getSubaccount(String userLogin) throws Exception {
        return this.getSubaccount(userLogin, Optional.empty());
    }

    public GetSubaccountDetailsResponse getSubaccount(String userLogin, Optional<Options> options) throws Exception {
        GetSubaccountDetailsRequest request = GetSubaccountDetailsRequest.builder().userLogin(userLogin).build();
        GetSubaccountDetails.Sync operation = new GetSubaccountDetails.Sync(this.sdkConfiguration, options, _headers);
        return (GetSubaccountDetailsResponse)operation.handleResponse(operation.doRequest(request));
    }
}

