/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.gsmservice.gateway.Accounts;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.models.operations.GetSubaccountDetailsRequest;
import pl.gsmservice.gateway.models.operations.async.GetAccountDetailsRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.GetAccountDetailsResponse;
import pl.gsmservice.gateway.models.operations.async.GetSubaccountDetailsRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.GetSubaccountDetailsResponse;
import pl.gsmservice.gateway.operations.GetAccountDetails;
import pl.gsmservice.gateway.operations.GetSubaccountDetails;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;

public class AsyncAccounts {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Accounts syncSDK;

    AsyncAccounts(Accounts syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    public Accounts sync() {
        return this.syncSDK;
    }

    public GetAccountDetailsRequestBuilder get() {
        return new GetAccountDetailsRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<GetAccountDetailsResponse> getDirect() {
        return this.get(Optional.empty());
    }

    public CompletableFuture<GetAccountDetailsResponse> get(Optional<Options> options) {
        GetAccountDetails.Async operation = new GetAccountDetails.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest().thenCompose(operation::handleResponse);
    }

    public GetSubaccountDetailsRequestBuilder getSubaccount() {
        return new GetSubaccountDetailsRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<GetSubaccountDetailsResponse> getSubaccount(String userLogin) {
        return this.getSubaccount(userLogin, Optional.empty());
    }

    public CompletableFuture<GetSubaccountDetailsResponse> getSubaccount(String userLogin, Optional<Options> options) {
        GetSubaccountDetailsRequest request = GetSubaccountDetailsRequest.builder().userLogin(userLogin).build();
        GetSubaccountDetails.Async operation = new GetSubaccountDetails.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

