/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.gsmservice.gateway.Common;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.models.operations.async.PingRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.PingResponse;
import pl.gsmservice.gateway.operations.Ping;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;

public class AsyncCommon {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Common syncSDK;

    AsyncCommon(Common syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    public Common sync() {
        return this.syncSDK;
    }

    public PingRequestBuilder ping() {
        return new PingRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<PingResponse> pingDirect() {
        return this.ping(Optional.empty());
    }

    public CompletableFuture<PingResponse> ping(Optional<Options> options) {
        Ping.Async operation = new Ping.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest().thenCompose(operation::handleResponse);
    }
}

