/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.gsmservice.gateway.Incoming;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.models.operations.GetIncomingMessagesRequest;
import pl.gsmservice.gateway.models.operations.ListIncomingMessagesRequest;
import pl.gsmservice.gateway.models.operations.async.GetIncomingMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.GetIncomingMessagesResponse;
import pl.gsmservice.gateway.models.operations.async.ListIncomingMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.ListIncomingMessagesResponse;
import pl.gsmservice.gateway.operations.GetIncomingMessages;
import pl.gsmservice.gateway.operations.ListIncomingMessages;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;

public class AsyncIncoming {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Incoming syncSDK;

    AsyncIncoming(Incoming syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    public Incoming sync() {
        return this.syncSDK;
    }

    public ListIncomingMessagesRequestBuilder list() {
        return new ListIncomingMessagesRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<ListIncomingMessagesResponse> listDirect() {
        return this.list(Optional.empty(), Optional.empty(), Optional.empty());
    }

    public CompletableFuture<ListIncomingMessagesResponse> list(Optional<Long> page, Optional<Long> limit, Optional<Options> options) {
        ListIncomingMessagesRequest request = ListIncomingMessagesRequest.builder().page(page).limit(limit).build();
        ListIncomingMessages.Async operation = new ListIncomingMessages.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public GetIncomingMessagesRequestBuilder getByIds() {
        return new GetIncomingMessagesRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<GetIncomingMessagesResponse> getByIds(List<Long> ids) {
        return this.getByIds(ids, Optional.empty());
    }

    public CompletableFuture<GetIncomingMessagesResponse> getByIds(List<Long> ids, Optional<Options> options) {
        GetIncomingMessagesRequest request = GetIncomingMessagesRequest.builder().ids(ids).build();
        GetIncomingMessages.Async operation = new GetIncomingMessages.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

