/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.gsmservice.gateway.Mms;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.models.operations.GetMmsPriceRequestBody;
import pl.gsmservice.gateway.models.operations.SendMmsRequestBody;
import pl.gsmservice.gateway.models.operations.async.GetMmsPriceRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.GetMmsPriceResponse;
import pl.gsmservice.gateway.models.operations.async.SendMmsRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.SendMmsResponse;
import pl.gsmservice.gateway.operations.GetMmsPrice;
import pl.gsmservice.gateway.operations.SendMms;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;

public class AsyncMms {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Mms syncSDK;

    AsyncMms(Mms syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    public Mms sync() {
        return this.syncSDK;
    }

    public GetMmsPriceRequestBuilder getPrice() {
        return new GetMmsPriceRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<GetMmsPriceResponse> getPrice(GetMmsPriceRequestBody request) {
        return this.getPrice(request, Optional.empty());
    }

    public CompletableFuture<GetMmsPriceResponse> getPrice(GetMmsPriceRequestBody request, Optional<Options> options) {
        GetMmsPrice.Async operation = new GetMmsPrice.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public SendMmsRequestBuilder send() {
        return new SendMmsRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<SendMmsResponse> send(SendMmsRequestBody request) {
        return this.send(request, Optional.empty());
    }

    public CompletableFuture<SendMmsResponse> send(SendMmsRequestBody request, Optional<Options> options) {
        SendMms.Async operation = new SendMms.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

