/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.gsmservice.gateway.AsyncMms;
import pl.gsmservice.gateway.AsyncSms;
import pl.gsmservice.gateway.Outgoing;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.models.operations.CancelMessagesRequest;
import pl.gsmservice.gateway.models.operations.GetMessagesRequest;
import pl.gsmservice.gateway.models.operations.ListMessagesRequest;
import pl.gsmservice.gateway.models.operations.async.CancelMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.CancelMessagesResponse;
import pl.gsmservice.gateway.models.operations.async.GetMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.GetMessagesResponse;
import pl.gsmservice.gateway.models.operations.async.ListMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.ListMessagesResponse;
import pl.gsmservice.gateway.operations.CancelMessages;
import pl.gsmservice.gateway.operations.GetMessages;
import pl.gsmservice.gateway.operations.ListMessages;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;

public class AsyncOutgoing {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncMms mms;
    private final AsyncSms sms;
    private final Outgoing syncSDK;

    AsyncOutgoing(Outgoing syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.mms = new AsyncMms(syncSDK.mms(), this.sdkConfiguration);
        this.sms = new AsyncSms(syncSDK.sms(), this.sdkConfiguration);
        this.syncSDK = syncSDK;
    }

    public final AsyncMms mms() {
        return this.mms;
    }

    public final AsyncSms sms() {
        return this.sms;
    }

    public Outgoing sync() {
        return this.syncSDK;
    }

    public GetMessagesRequestBuilder getByIds() {
        return new GetMessagesRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<GetMessagesResponse> getByIds(List<Long> ids) {
        return this.getByIds(ids, Optional.empty());
    }

    public CompletableFuture<GetMessagesResponse> getByIds(List<Long> ids, Optional<Options> options) {
        GetMessagesRequest request = GetMessagesRequest.builder().ids(ids).build();
        GetMessages.Async operation = new GetMessages.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public CancelMessagesRequestBuilder cancelScheduled() {
        return new CancelMessagesRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<CancelMessagesResponse> cancelScheduled(List<Long> ids) {
        return this.cancelScheduled(ids, Optional.empty());
    }

    public CompletableFuture<CancelMessagesResponse> cancelScheduled(List<Long> ids, Optional<Options> options) {
        CancelMessagesRequest request = CancelMessagesRequest.builder().ids(ids).build();
        CancelMessages.Async operation = new CancelMessages.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public ListMessagesRequestBuilder list() {
        return new ListMessagesRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<ListMessagesResponse> listDirect() {
        return this.list(Optional.empty(), Optional.empty(), Optional.empty());
    }

    public CompletableFuture<ListMessagesResponse> list(Optional<Long> page, Optional<Long> limit, Optional<Options> options) {
        ListMessagesRequest request = ListMessagesRequest.builder().page(page).limit(limit).build();
        ListMessages.Async operation = new ListMessages.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

