/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.Senders;
import pl.gsmservice.gateway.models.components.SenderInput;
import pl.gsmservice.gateway.models.operations.DeleteSenderRequest;
import pl.gsmservice.gateway.models.operations.SetDefaultSenderRequest;
import pl.gsmservice.gateway.models.operations.async.AddSenderRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.AddSenderResponse;
import pl.gsmservice.gateway.models.operations.async.DeleteSenderRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.DeleteSenderResponse;
import pl.gsmservice.gateway.models.operations.async.ListSendersRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.ListSendersResponse;
import pl.gsmservice.gateway.models.operations.async.SetDefaultSenderRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.SetDefaultSenderResponse;
import pl.gsmservice.gateway.operations.AddSender;
import pl.gsmservice.gateway.operations.DeleteSender;
import pl.gsmservice.gateway.operations.ListSenders;
import pl.gsmservice.gateway.operations.SetDefaultSender;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;

public class AsyncSenders {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Senders syncSDK;

    AsyncSenders(Senders syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    public Senders sync() {
        return this.syncSDK;
    }

    public ListSendersRequestBuilder list() {
        return new ListSendersRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<ListSendersResponse> listDirect() {
        return this.list(Optional.empty());
    }

    public CompletableFuture<ListSendersResponse> list(Optional<Options> options) {
        ListSenders.Async operation = new ListSenders.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest().thenCompose(operation::handleResponse);
    }

    public AddSenderRequestBuilder add() {
        return new AddSenderRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<AddSenderResponse> add(SenderInput request) {
        return this.add(request, Optional.empty());
    }

    public CompletableFuture<AddSenderResponse> add(SenderInput request, Optional<Options> options) {
        AddSender.Async operation = new AddSender.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public DeleteSenderRequestBuilder delete() {
        return new DeleteSenderRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<DeleteSenderResponse> delete(String sender) {
        return this.delete(sender, Optional.empty());
    }

    public CompletableFuture<DeleteSenderResponse> delete(String sender, Optional<Options> options) {
        DeleteSenderRequest request = DeleteSenderRequest.builder().sender(sender).build();
        DeleteSender.Async operation = new DeleteSender.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public SetDefaultSenderRequestBuilder setDefault() {
        return new SetDefaultSenderRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<SetDefaultSenderResponse> setDefault(String sender) {
        return this.setDefault(sender, Optional.empty());
    }

    public CompletableFuture<SetDefaultSenderResponse> setDefault(String sender, Optional<Options> options) {
        SetDefaultSenderRequest request = SetDefaultSenderRequest.builder().sender(sender).build();
        SetDefaultSender.Async operation = new SetDefaultSender.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

