/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.Sms;
import pl.gsmservice.gateway.models.operations.GetSmsPriceRequestBody;
import pl.gsmservice.gateway.models.operations.SendSmsRequestBody;
import pl.gsmservice.gateway.models.operations.async.GetSmsPriceRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.GetSmsPriceResponse;
import pl.gsmservice.gateway.models.operations.async.SendSmsRequestBuilder;
import pl.gsmservice.gateway.models.operations.async.SendSmsResponse;
import pl.gsmservice.gateway.operations.GetSmsPrice;
import pl.gsmservice.gateway.operations.SendSms;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;

public class AsyncSms {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Sms syncSDK;

    AsyncSms(Sms syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    public Sms sync() {
        return this.syncSDK;
    }

    public GetSmsPriceRequestBuilder getPrice() {
        return new GetSmsPriceRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<GetSmsPriceResponse> getPrice(GetSmsPriceRequestBody request) {
        return this.getPrice(request, Optional.empty());
    }

    public CompletableFuture<GetSmsPriceResponse> getPrice(GetSmsPriceRequestBody request, Optional<Options> options) {
        GetSmsPrice.Async operation = new GetSmsPrice.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public SendSmsRequestBuilder send() {
        return new SendSmsRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<SendSmsResponse> send(SendSmsRequestBody request) {
        return this.send(request, Optional.empty());
    }

    public CompletableFuture<SendSmsResponse> send(SendSmsRequestBody request, Optional<Options> options) {
        SendSms.Async operation = new SendSms.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

