/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import pl.gsmservice.gateway.Accounts;
import pl.gsmservice.gateway.AsyncClient;
import pl.gsmservice.gateway.Common;
import pl.gsmservice.gateway.Incoming;
import pl.gsmservice.gateway.Outgoing;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.SecuritySource;
import pl.gsmservice.gateway.Senders;
import pl.gsmservice.gateway.models.components.Security;
import pl.gsmservice.gateway.utils.HTTPClient;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.RetryConfig;
import pl.gsmservice.gateway.utils.Utils;

public class Client {
    private static final Headers _headers = Headers.EMPTY;
    public static final Map<AvailableServers, String> SERVERS = new HashMap<AvailableServers, String>(){
        {
            this.put(AvailableServers.PROD, "https://api.szybkisms.pl/rest");
            this.put(AvailableServers.SANDBOX, "https://api.szybkisms.pl/rest-sandbox");
        }
    };
    private final Accounts accounts;
    private final Outgoing outgoing;
    private final Incoming incoming;
    private final Common common;
    private final Senders senders;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncClient asyncSDK;

    public Accounts accounts() {
        return this.accounts;
    }

    public Outgoing outgoing() {
        return this.outgoing;
    }

    public Incoming incoming() {
        return this.incoming;
    }

    public Common common() {
        return this.common;
    }

    public Senders senders() {
        return this.senders;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Client(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.sdkConfiguration.initialize();
        this.accounts = new Accounts(sdkConfiguration);
        this.outgoing = new Outgoing(sdkConfiguration);
        this.incoming = new Incoming(sdkConfiguration);
        this.common = new Common(sdkConfiguration);
        this.senders = new Senders(sdkConfiguration);
        this.asyncSDK = new AsyncClient(this, sdkConfiguration);
    }

    public AsyncClient async() {
        return this.asyncSDK;
    }

    public static class Builder {
        private final SDKConfiguration sdkConfiguration = new SDKConfiguration();
        private String serverUrl;
        private String server;

        private Builder() {
        }

        public Builder client(HTTPClient client) {
            this.sdkConfiguration.setClient(client);
            return this;
        }

        public Builder bearer(String bearer) {
            this.sdkConfiguration.setSecuritySource(SecuritySource.of(Security.builder().bearer(bearer).build()));
            return this;
        }

        public Builder securitySource(SecuritySource securitySource) {
            Utils.checkNotNull(securitySource, "securitySource");
            this.sdkConfiguration.setSecuritySource(securitySource);
            return this;
        }

        public Builder serverURL(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public Builder serverURL(String serverUrl, Map<String, String> params) {
            this.serverUrl = Utils.templateUrl(serverUrl, params);
            return this;
        }

        public Builder server(AvailableServers server) {
            this.server = server.server();
            this.serverUrl = SERVERS.get((Object)server);
            return this;
        }

        public Builder retryConfig(RetryConfig retryConfig) {
            this.sdkConfiguration.setRetryConfig(Optional.of(retryConfig));
            return this;
        }

        public Builder enableHTTPDebugLogging(boolean enabled) {
            this.sdkConfiguration.client().enableDebugLogging(enabled);
            return this;
        }

        public Client build() {
            if (this.serverUrl == null || this.serverUrl.isBlank()) {
                this.serverUrl = SERVERS.get((Object)AvailableServers.PROD);
                this.server = AvailableServers.PROD.server();
            }
            this.sdkConfiguration.setServerUrl(this.serverUrl);
            if (this.server != null) {
                this.sdkConfiguration.setServer(this.server);
            }
            return new Client(this.sdkConfiguration);
        }
    }

    public static enum AvailableServers {
        PROD("prod"),
        SANDBOX("sandbox");

        private final String server;

        private AvailableServers(String server) {
            this.server = server;
        }

        public String server() {
            return this.server;
        }
    }
}

