/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway;

import java.util.List;
import java.util.Optional;
import pl.gsmservice.gateway.AsyncIncoming;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.models.operations.GetIncomingMessagesRequest;
import pl.gsmservice.gateway.models.operations.GetIncomingMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.GetIncomingMessagesResponse;
import pl.gsmservice.gateway.models.operations.ListIncomingMessagesRequest;
import pl.gsmservice.gateway.models.operations.ListIncomingMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.ListIncomingMessagesResponse;
import pl.gsmservice.gateway.operations.GetIncomingMessages;
import pl.gsmservice.gateway.operations.ListIncomingMessages;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;

public class Incoming {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncIncoming asyncSDK;

    Incoming(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncIncoming(this, sdkConfiguration);
    }

    public AsyncIncoming async() {
        return this.asyncSDK;
    }

    public ListIncomingMessagesRequestBuilder list() {
        return new ListIncomingMessagesRequestBuilder(this.sdkConfiguration);
    }

    public ListIncomingMessagesResponse listDirect() throws Exception {
        return this.list(Optional.empty(), Optional.empty(), Optional.empty());
    }

    public ListIncomingMessagesResponse list(Optional<Long> page, Optional<Long> limit, Optional<Options> options) throws Exception {
        ListIncomingMessagesRequest request = ListIncomingMessagesRequest.builder().page(page).limit(limit).build();
        ListIncomingMessages.Sync operation = new ListIncomingMessages.Sync(this.sdkConfiguration, options, _headers);
        return (ListIncomingMessagesResponse)operation.handleResponse(operation.doRequest(request));
    }

    public GetIncomingMessagesRequestBuilder getByIds() {
        return new GetIncomingMessagesRequestBuilder(this.sdkConfiguration);
    }

    public GetIncomingMessagesResponse getByIds(List<Long> ids) throws Exception {
        return this.getByIds(ids, Optional.empty());
    }

    public GetIncomingMessagesResponse getByIds(List<Long> ids, Optional<Options> options) throws Exception {
        GetIncomingMessagesRequest request = GetIncomingMessagesRequest.builder().ids(ids).build();
        GetIncomingMessages.Sync operation = new GetIncomingMessages.Sync(this.sdkConfiguration, options, _headers);
        return (GetIncomingMessagesResponse)operation.handleResponse(operation.doRequest(request));
    }
}

