/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway;

import java.util.List;
import java.util.Optional;
import pl.gsmservice.gateway.AsyncOutgoing;
import pl.gsmservice.gateway.Mms;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.Sms;
import pl.gsmservice.gateway.models.operations.CancelMessagesRequest;
import pl.gsmservice.gateway.models.operations.CancelMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.CancelMessagesResponse;
import pl.gsmservice.gateway.models.operations.GetMessagesRequest;
import pl.gsmservice.gateway.models.operations.GetMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.GetMessagesResponse;
import pl.gsmservice.gateway.models.operations.ListMessagesRequest;
import pl.gsmservice.gateway.models.operations.ListMessagesRequestBuilder;
import pl.gsmservice.gateway.models.operations.ListMessagesResponse;
import pl.gsmservice.gateway.operations.CancelMessages;
import pl.gsmservice.gateway.operations.GetMessages;
import pl.gsmservice.gateway.operations.ListMessages;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;

public class Outgoing {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncOutgoing asyncSDK;
    private final Mms mms;
    private final Sms sms;

    Outgoing(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.mms = new Mms(this.sdkConfiguration);
        this.sms = new Sms(this.sdkConfiguration);
        this.asyncSDK = new AsyncOutgoing(this, sdkConfiguration);
    }

    public final Mms mms() {
        return this.mms;
    }

    public final Sms sms() {
        return this.sms;
    }

    public AsyncOutgoing async() {
        return this.asyncSDK;
    }

    public GetMessagesRequestBuilder getByIds() {
        return new GetMessagesRequestBuilder(this.sdkConfiguration);
    }

    public GetMessagesResponse getByIds(List<Long> ids) throws Exception {
        return this.getByIds(ids, Optional.empty());
    }

    public GetMessagesResponse getByIds(List<Long> ids, Optional<Options> options) throws Exception {
        GetMessagesRequest request = GetMessagesRequest.builder().ids(ids).build();
        GetMessages.Sync operation = new GetMessages.Sync(this.sdkConfiguration, options, _headers);
        return (GetMessagesResponse)operation.handleResponse(operation.doRequest(request));
    }

    public CancelMessagesRequestBuilder cancelScheduled() {
        return new CancelMessagesRequestBuilder(this.sdkConfiguration);
    }

    public CancelMessagesResponse cancelScheduled(List<Long> ids) throws Exception {
        return this.cancelScheduled(ids, Optional.empty());
    }

    public CancelMessagesResponse cancelScheduled(List<Long> ids, Optional<Options> options) throws Exception {
        CancelMessagesRequest request = CancelMessagesRequest.builder().ids(ids).build();
        CancelMessages.Sync operation = new CancelMessages.Sync(this.sdkConfiguration, options, _headers);
        return (CancelMessagesResponse)operation.handleResponse(operation.doRequest(request));
    }

    public ListMessagesRequestBuilder list() {
        return new ListMessagesRequestBuilder(this.sdkConfiguration);
    }

    public ListMessagesResponse listDirect() throws Exception {
        return this.list(Optional.empty(), Optional.empty(), Optional.empty());
    }

    public ListMessagesResponse list(Optional<Long> page, Optional<Long> limit, Optional<Options> options) throws Exception {
        ListMessagesRequest request = ListMessagesRequest.builder().page(page).limit(limit).build();
        ListMessages.Sync operation = new ListMessages.Sync(this.sdkConfiguration, options, _headers);
        return (ListMessagesResponse)operation.handleResponse(operation.doRequest(request));
    }
}

