/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway;

import java.util.Optional;
import pl.gsmservice.gateway.AsyncSenders;
import pl.gsmservice.gateway.SDKConfiguration;
import pl.gsmservice.gateway.models.components.SenderInput;
import pl.gsmservice.gateway.models.operations.AddSenderRequestBuilder;
import pl.gsmservice.gateway.models.operations.AddSenderResponse;
import pl.gsmservice.gateway.models.operations.DeleteSenderRequest;
import pl.gsmservice.gateway.models.operations.DeleteSenderRequestBuilder;
import pl.gsmservice.gateway.models.operations.DeleteSenderResponse;
import pl.gsmservice.gateway.models.operations.ListSendersRequestBuilder;
import pl.gsmservice.gateway.models.operations.ListSendersResponse;
import pl.gsmservice.gateway.models.operations.SetDefaultSenderRequest;
import pl.gsmservice.gateway.models.operations.SetDefaultSenderRequestBuilder;
import pl.gsmservice.gateway.models.operations.SetDefaultSenderResponse;
import pl.gsmservice.gateway.operations.AddSender;
import pl.gsmservice.gateway.operations.DeleteSender;
import pl.gsmservice.gateway.operations.ListSenders;
import pl.gsmservice.gateway.operations.SetDefaultSender;
import pl.gsmservice.gateway.utils.Headers;
import pl.gsmservice.gateway.utils.Options;

public class Senders {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncSenders asyncSDK;

    Senders(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncSenders(this, sdkConfiguration);
    }

    public AsyncSenders async() {
        return this.asyncSDK;
    }

    public ListSendersRequestBuilder list() {
        return new ListSendersRequestBuilder(this.sdkConfiguration);
    }

    public ListSendersResponse listDirect() throws Exception {
        return this.list(Optional.empty());
    }

    public ListSendersResponse list(Optional<Options> options) throws Exception {
        ListSenders.Sync operation = new ListSenders.Sync(this.sdkConfiguration, options, _headers);
        return (ListSendersResponse)operation.handleResponse(operation.doRequest());
    }

    public AddSenderRequestBuilder add() {
        return new AddSenderRequestBuilder(this.sdkConfiguration);
    }

    public AddSenderResponse add(SenderInput request) throws Exception {
        return this.add(request, Optional.empty());
    }

    public AddSenderResponse add(SenderInput request, Optional<Options> options) throws Exception {
        AddSender.Sync operation = new AddSender.Sync(this.sdkConfiguration, options, _headers);
        return (AddSenderResponse)operation.handleResponse(operation.doRequest(request));
    }

    public DeleteSenderRequestBuilder delete() {
        return new DeleteSenderRequestBuilder(this.sdkConfiguration);
    }

    public DeleteSenderResponse delete(String sender) throws Exception {
        return this.delete(sender, Optional.empty());
    }

    public DeleteSenderResponse delete(String sender, Optional<Options> options) throws Exception {
        DeleteSenderRequest request = DeleteSenderRequest.builder().sender(sender).build();
        DeleteSender.Sync operation = new DeleteSender.Sync(this.sdkConfiguration, options, _headers);
        return (DeleteSenderResponse)operation.handleResponse(operation.doRequest(request));
    }

    public SetDefaultSenderRequestBuilder setDefault() {
        return new SetDefaultSenderRequestBuilder(this.sdkConfiguration);
    }

    public SetDefaultSenderResponse setDefault(String sender) throws Exception {
        return this.setDefault(sender, Optional.empty());
    }

    public SetDefaultSenderResponse setDefault(String sender, Optional<Options> options) throws Exception {
        SetDefaultSenderRequest request = SetDefaultSenderRequest.builder().sender(sender).build();
        SetDefaultSender.Sync operation = new SetDefaultSender.Sync(this.sdkConfiguration, options, _headers);
        return (SetDefaultSenderResponse)operation.handleResponse(operation.doRequest(request));
    }
}

