/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;
import pl.gsmservice.gateway.models.components.MessageType;
import pl.gsmservice.gateway.utils.Utils;

public class Message {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private JsonNullable<Long> id;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="cid")
    private JsonNullable<String> cid;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="type")
    private Optional<? extends MessageType> type;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="recipient")
    private Optional<String> recipient;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="sender")
    private JsonNullable<String> sender;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="parts")
    private JsonNullable<Long> parts;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="sent_date")
    private JsonNullable<OffsetDateTime> sentDate;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="status_date")
    private JsonNullable<OffsetDateTime> statusDate;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="status_code")
    private Optional<String> statusCode;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="status_description")
    private Optional<String> statusDescription;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="unicode")
    private Optional<Boolean> unicode;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="flash")
    private Optional<Boolean> flash;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="price")
    private Optional<Float> price;

    @JsonCreator
    public Message(@JsonProperty(value="id") JsonNullable<Long> id, @JsonProperty(value="cid") JsonNullable<String> cid, @JsonProperty(value="type") Optional<? extends MessageType> type, @JsonProperty(value="recipient") Optional<String> recipient, @JsonProperty(value="sender") JsonNullable<String> sender, @JsonProperty(value="parts") JsonNullable<Long> parts, @JsonProperty(value="sent_date") JsonNullable<OffsetDateTime> sentDate, @JsonProperty(value="status_date") JsonNullable<OffsetDateTime> statusDate, @JsonProperty(value="status_code") Optional<String> statusCode, @JsonProperty(value="status_description") Optional<String> statusDescription, @JsonProperty(value="unicode") Optional<Boolean> unicode, @JsonProperty(value="flash") Optional<Boolean> flash, @JsonProperty(value="price") Optional<Float> price) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(cid, "cid");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(recipient, "recipient");
        Utils.checkNotNull(sender, "sender");
        Utils.checkNotNull(parts, "parts");
        Utils.checkNotNull(sentDate, "sentDate");
        Utils.checkNotNull(statusDate, "statusDate");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(statusDescription, "statusDescription");
        Utils.checkNotNull(unicode, "unicode");
        Utils.checkNotNull(flash, "flash");
        Utils.checkNotNull(price, "price");
        this.id = id;
        this.cid = cid;
        this.type = type;
        this.recipient = recipient;
        this.sender = sender;
        this.parts = parts;
        this.sentDate = sentDate;
        this.statusDate = statusDate;
        this.statusCode = statusCode;
        this.statusDescription = statusDescription;
        this.unicode = unicode;
        this.flash = flash;
        this.price = price;
    }

    public Message() {
        this((JsonNullable<Long>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<Long>)JsonNullable.undefined(), (JsonNullable<OffsetDateTime>)JsonNullable.undefined(), (JsonNullable<OffsetDateTime>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public JsonNullable<Long> id() {
        return this.id;
    }

    @JsonIgnore
    public JsonNullable<String> cid() {
        return this.cid;
    }

    @JsonIgnore
    public Optional<MessageType> type() {
        return this.type;
    }

    @JsonIgnore
    public Optional<String> recipient() {
        return this.recipient;
    }

    @JsonIgnore
    public JsonNullable<String> sender() {
        return this.sender;
    }

    @JsonIgnore
    public JsonNullable<Long> parts() {
        return this.parts;
    }

    @JsonIgnore
    public JsonNullable<OffsetDateTime> sentDate() {
        return this.sentDate;
    }

    @JsonIgnore
    public JsonNullable<OffsetDateTime> statusDate() {
        return this.statusDate;
    }

    @JsonIgnore
    public Optional<String> statusCode() {
        return this.statusCode;
    }

    @JsonIgnore
    public Optional<String> statusDescription() {
        return this.statusDescription;
    }

    @JsonIgnore
    public Optional<Boolean> unicode() {
        return this.unicode;
    }

    @JsonIgnore
    public Optional<Boolean> flash() {
        return this.flash;
    }

    @JsonIgnore
    public Optional<Float> price() {
        return this.price;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Message withId(long id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of((Object)id);
        return this;
    }

    public Message withId(JsonNullable<Long> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Message withCid(String cid) {
        Utils.checkNotNull(cid, "cid");
        this.cid = JsonNullable.of((Object)cid);
        return this;
    }

    public Message withCid(JsonNullable<String> cid) {
        Utils.checkNotNull(cid, "cid");
        this.cid = cid;
        return this;
    }

    public Message withType(MessageType type) {
        Utils.checkNotNull(type, "type");
        this.type = Optional.ofNullable(type);
        return this;
    }

    public Message withType(Optional<? extends MessageType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    public Message withRecipient(String recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = Optional.ofNullable(recipient);
        return this;
    }

    public Message withRecipient(Optional<String> recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = recipient;
        return this;
    }

    public Message withSender(String sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = JsonNullable.of((Object)sender);
        return this;
    }

    public Message withSender(JsonNullable<String> sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = sender;
        return this;
    }

    public Message withParts(long parts) {
        Utils.checkNotNull(parts, "parts");
        this.parts = JsonNullable.of((Object)parts);
        return this;
    }

    public Message withParts(JsonNullable<Long> parts) {
        Utils.checkNotNull(parts, "parts");
        this.parts = parts;
        return this;
    }

    public Message withSentDate(OffsetDateTime sentDate) {
        Utils.checkNotNull(sentDate, "sentDate");
        this.sentDate = JsonNullable.of((Object)sentDate);
        return this;
    }

    public Message withSentDate(JsonNullable<OffsetDateTime> sentDate) {
        Utils.checkNotNull(sentDate, "sentDate");
        this.sentDate = sentDate;
        return this;
    }

    public Message withStatusDate(OffsetDateTime statusDate) {
        Utils.checkNotNull(statusDate, "statusDate");
        this.statusDate = JsonNullable.of((Object)statusDate);
        return this;
    }

    public Message withStatusDate(JsonNullable<OffsetDateTime> statusDate) {
        Utils.checkNotNull(statusDate, "statusDate");
        this.statusDate = statusDate;
        return this;
    }

    public Message withStatusCode(String statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = Optional.ofNullable(statusCode);
        return this;
    }

    public Message withStatusCode(Optional<String> statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public Message withStatusDescription(String statusDescription) {
        Utils.checkNotNull(statusDescription, "statusDescription");
        this.statusDescription = Optional.ofNullable(statusDescription);
        return this;
    }

    public Message withStatusDescription(Optional<String> statusDescription) {
        Utils.checkNotNull(statusDescription, "statusDescription");
        this.statusDescription = statusDescription;
        return this;
    }

    public Message withUnicode(boolean unicode) {
        Utils.checkNotNull(unicode, "unicode");
        this.unicode = Optional.ofNullable(unicode);
        return this;
    }

    public Message withUnicode(Optional<Boolean> unicode) {
        Utils.checkNotNull(unicode, "unicode");
        this.unicode = unicode;
        return this;
    }

    public Message withFlash(boolean flash) {
        Utils.checkNotNull(flash, "flash");
        this.flash = Optional.ofNullable(flash);
        return this;
    }

    public Message withFlash(Optional<Boolean> flash) {
        Utils.checkNotNull(flash, "flash");
        this.flash = flash;
        return this;
    }

    public Message withPrice(float price) {
        Utils.checkNotNull(Float.valueOf(price), "price");
        this.price = Optional.ofNullable(Float.valueOf(price));
        return this;
    }

    public Message withPrice(Optional<Float> price) {
        Utils.checkNotNull(price, "price");
        this.price = price;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message other = (Message)o;
        return Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.cid, other.cid) && Utils.enhancedDeepEquals(this.type, other.type) && Utils.enhancedDeepEquals(this.recipient, other.recipient) && Utils.enhancedDeepEquals(this.sender, other.sender) && Utils.enhancedDeepEquals(this.parts, other.parts) && Utils.enhancedDeepEquals(this.sentDate, other.sentDate) && Utils.enhancedDeepEquals(this.statusDate, other.statusDate) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.statusDescription, other.statusDescription) && Utils.enhancedDeepEquals(this.unicode, other.unicode) && Utils.enhancedDeepEquals(this.flash, other.flash) && Utils.enhancedDeepEquals(this.price, other.price);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.id, this.cid, this.type, this.recipient, this.sender, this.parts, this.sentDate, this.statusDate, this.statusCode, this.statusDescription, this.unicode, this.flash, this.price);
    }

    public String toString() {
        return Utils.toString(Message.class, "id", this.id, "cid", this.cid, "type", this.type, "recipient", this.recipient, "sender", this.sender, "parts", this.parts, "sentDate", this.sentDate, "statusDate", this.statusDate, "statusCode", this.statusCode, "statusDescription", this.statusDescription, "unicode", this.unicode, "flash", this.flash, "price", this.price);
    }

    public static final class Builder {
        private JsonNullable<Long> id = JsonNullable.undefined();
        private JsonNullable<String> cid = JsonNullable.undefined();
        private Optional<? extends MessageType> type = Optional.empty();
        private Optional<String> recipient = Optional.empty();
        private JsonNullable<String> sender = JsonNullable.undefined();
        private JsonNullable<Long> parts = JsonNullable.undefined();
        private JsonNullable<OffsetDateTime> sentDate = JsonNullable.undefined();
        private JsonNullable<OffsetDateTime> statusDate = JsonNullable.undefined();
        private Optional<String> statusCode = Optional.empty();
        private Optional<String> statusDescription = Optional.empty();
        private Optional<Boolean> unicode = Optional.empty();
        private Optional<Boolean> flash = Optional.empty();
        private Optional<Float> price = Optional.empty();

        private Builder() {
        }

        public Builder id(long id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of((Object)id);
            return this;
        }

        public Builder id(JsonNullable<Long> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder cid(String cid) {
            Utils.checkNotNull(cid, "cid");
            this.cid = JsonNullable.of((Object)cid);
            return this;
        }

        public Builder cid(JsonNullable<String> cid) {
            Utils.checkNotNull(cid, "cid");
            this.cid = cid;
            return this;
        }

        public Builder type(MessageType type) {
            Utils.checkNotNull(type, "type");
            this.type = Optional.ofNullable(type);
            return this;
        }

        public Builder type(Optional<? extends MessageType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        public Builder recipient(String recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = Optional.ofNullable(recipient);
            return this;
        }

        public Builder recipient(Optional<String> recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = recipient;
            return this;
        }

        public Builder sender(String sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = JsonNullable.of((Object)sender);
            return this;
        }

        public Builder sender(JsonNullable<String> sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = sender;
            return this;
        }

        public Builder parts(long parts) {
            Utils.checkNotNull(parts, "parts");
            this.parts = JsonNullable.of((Object)parts);
            return this;
        }

        public Builder parts(JsonNullable<Long> parts) {
            Utils.checkNotNull(parts, "parts");
            this.parts = parts;
            return this;
        }

        public Builder sentDate(OffsetDateTime sentDate) {
            Utils.checkNotNull(sentDate, "sentDate");
            this.sentDate = JsonNullable.of((Object)sentDate);
            return this;
        }

        public Builder sentDate(JsonNullable<OffsetDateTime> sentDate) {
            Utils.checkNotNull(sentDate, "sentDate");
            this.sentDate = sentDate;
            return this;
        }

        public Builder statusDate(OffsetDateTime statusDate) {
            Utils.checkNotNull(statusDate, "statusDate");
            this.statusDate = JsonNullable.of((Object)statusDate);
            return this;
        }

        public Builder statusDate(JsonNullable<OffsetDateTime> statusDate) {
            Utils.checkNotNull(statusDate, "statusDate");
            this.statusDate = statusDate;
            return this;
        }

        public Builder statusCode(String statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = Optional.ofNullable(statusCode);
            return this;
        }

        public Builder statusCode(Optional<String> statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder statusDescription(String statusDescription) {
            Utils.checkNotNull(statusDescription, "statusDescription");
            this.statusDescription = Optional.ofNullable(statusDescription);
            return this;
        }

        public Builder statusDescription(Optional<String> statusDescription) {
            Utils.checkNotNull(statusDescription, "statusDescription");
            this.statusDescription = statusDescription;
            return this;
        }

        public Builder unicode(boolean unicode) {
            Utils.checkNotNull(unicode, "unicode");
            this.unicode = Optional.ofNullable(unicode);
            return this;
        }

        public Builder unicode(Optional<Boolean> unicode) {
            Utils.checkNotNull(unicode, "unicode");
            this.unicode = unicode;
            return this;
        }

        public Builder flash(boolean flash) {
            Utils.checkNotNull(flash, "flash");
            this.flash = Optional.ofNullable(flash);
            return this;
        }

        public Builder flash(Optional<Boolean> flash) {
            Utils.checkNotNull(flash, "flash");
            this.flash = flash;
            return this;
        }

        public Builder price(float price) {
            Utils.checkNotNull(Float.valueOf(price), "price");
            this.price = Optional.ofNullable(Float.valueOf(price));
            return this;
        }

        public Builder price(Optional<Float> price) {
            Utils.checkNotNull(price, "price");
            this.price = price;
            return this;
        }

        public Message build() {
            return new Message(this.id, this.cid, this.type, this.recipient, this.sender, this.parts, this.sentDate, this.statusDate, this.statusCode, this.statusDescription, this.unicode, this.flash, this.price);
        }
    }
}

