/*
 * Decompiled with CFR 0.152.
 */
package pl.gsmservice.gateway.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class MessageType {
    public static final MessageType SmsPro = new MessageType(1L);
    public static final MessageType SmsEco = new MessageType(3L);
    public static final MessageType SmsTwoWay = new MessageType(4L);
    public static final MessageType Mms = new MessageType(10L);
    private static final Map<Long, MessageType> values = MessageType.createValuesMap();
    private static final Map<Long, MessageTypeEnum> enums = MessageType.createEnumsMap();
    private final long value;

    private MessageType(long value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageType of(long value) {
        Class<MessageType> clazz = MessageType.class;
        synchronized (MessageType.class) {
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new MessageType((long)v));
        }
    }

    public long value() {
        return this.value;
    }

    public Optional<MessageTypeEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageType other = (MessageType)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "MessageType [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageType[] values() {
        Class<MessageType> clazz = MessageType.class;
        synchronized (MessageType.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new MessageType[0]);
        }
    }

    private static final Map<Long, MessageType> createValuesMap() {
        LinkedHashMap<Long, MessageType> map = new LinkedHashMap<Long, MessageType>();
        map.put(1L, SmsPro);
        map.put(3L, SmsEco);
        map.put(4L, SmsTwoWay);
        map.put(10L, Mms);
        return map;
    }

    private static final Map<Long, MessageTypeEnum> createEnumsMap() {
        HashMap<Long, MessageTypeEnum> map = new HashMap<Long, MessageTypeEnum>();
        map.put(1L, MessageTypeEnum.SmsPro);
        map.put(3L, MessageTypeEnum.SmsEco);
        map.put(4L, MessageTypeEnum.SmsTwoWay);
        map.put(10L, MessageTypeEnum.Mms);
        return map;
    }

    public static enum MessageTypeEnum {
        SmsPro(1L),
        SmsEco(3L),
        SmsTwoWay(4L),
        Mms(10L);

        private final long value;

        private MessageTypeEnum(long value) {
            this.value = value;
        }

        public long value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<MessageType> {
        protected _Deserializer() {
            super(MessageType.class);
        }

        public MessageType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            long v = (Long)p.readValueAs((TypeReference)new TypeReference<Long>(){});
            return MessageType.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<MessageType> {
        protected _Serializer() {
            super(MessageType.class);
        }

        public void serialize(MessageType value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

